/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class StorageFacetCleanupTaskManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final String storageCleanupCron;

    @Inject
    public StorageFacetCleanupTaskManager(TaskScheduler taskScheduler, @Named(value="${nexus.storageCleanup.cron:-0 */10 * * * ?}") String storageCleanupCron) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.storageCleanupCron = (String)Preconditions.checkNotNull((Object)storageCleanupCron);
    }

    protected void doStart() throws Exception {
        this.taskScheduler.listsTasks().stream().filter(info -> "repository.storage-facet-cleanup".equals(info.getConfiguration().getTypeId())).forEach(TaskInfo::remove);
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.storage-facet-cleanup");
        Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), this.storageCleanupCron);
        this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
    }
}

