/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryMetadataUpdatedEvent;
import org.sonatype.nexus.repository.storage.internal.BucketUpdatedEvent;

@Named
@Singleton
public class BucketEventInspector
extends ComponentSupport
implements EventAware {
    private final RepositoryManager repositoryManager;
    private final EventManager eventManager;

    @Inject
    public BucketEventInspector(RepositoryManager repositoryManager, EventManager eventManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Subscribe
    public void onBucketUpdated(BucketUpdatedEvent event) {
        Repository repository = this.repositoryManager.get(event.getRepositoryName());
        if (repository != null) {
            this.eventManager.post((Object)new RepositoryMetadataUpdatedEvent(repository));
        } else {
            this.log.debug("Not posting metadata update event for deleted repository {}", (Object)event.getRepositoryName());
        }
    }
}

