/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuard;
import org.sonatype.nexus.common.stateguard.StateGuardAware;
import org.sonatype.nexus.common.stateguard.Transitions;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.move.RepositoryMoveService;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.BlobTx;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentFactory;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.MissingBlobException;
import org.sonatype.nexus.repository.storage.OrientAsyncHelper;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.RetryDeniedException;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.RetryController;

public class StorageTxImpl
implements StorageTx,
StateGuardAware {
    private static final Logger log = LoggerFactory.getLogger(StorageTxImpl.class);
    private final String createdBy;
    private final String createdByIp;
    private final BlobTx blobTx;
    private final ODatabaseDocumentTx db;
    private final String repositoryName;
    private final WritePolicy writePolicy;
    private final WritePolicySelector writePolicySelector;
    private final StateGuard stateGuard = new StateGuard.Builder().initial("OPEN").logger(log).create();
    private final BucketEntityAdapter bucketEntityAdapter;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final boolean strictContentValidation;
    private final ContentValidator contentValidator;
    private final MimeRulesSource mimeRulesSource;
    private final ComponentFactory componentFactory;
    private final Provider<RepositoryMoveService> repositoryMoveStoreProvider;
    private final NodeAccess nodeAccess;
    private int retries = 0;
    private String reason = "transaction";

    public StorageTxImpl(String createdBy, String createdByIp, BlobTx blobTx, ODatabaseDocumentTx db, String repositoryName, WritePolicy writePolicy, WritePolicySelector writePolicySelector, BucketEntityAdapter bucketEntityAdapter, ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, boolean strictContentValidation, ContentValidator contentValidator, MimeRulesSource mimeRulesSource, ComponentFactory componentFactory, Provider<RepositoryMoveService> repositoryMoveStoreProvider, NodeAccess nodeAccess) {
        this.createdBy = (String)Preconditions.checkNotNull((Object)createdBy);
        this.createdByIp = (String)Preconditions.checkNotNull((Object)createdByIp);
        this.blobTx = (BlobTx)Preconditions.checkNotNull((Object)blobTx);
        this.db = (ODatabaseDocumentTx)Preconditions.checkNotNull((Object)db);
        this.repositoryName = (String)Preconditions.checkNotNull((Object)repositoryName);
        this.writePolicy = (WritePolicy)Preconditions.checkNotNull((Object)writePolicy);
        this.writePolicySelector = (WritePolicySelector)Preconditions.checkNotNull((Object)writePolicySelector);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.strictContentValidation = strictContentValidation;
        this.contentValidator = (ContentValidator)Preconditions.checkNotNull((Object)contentValidator);
        this.mimeRulesSource = (MimeRulesSource)Preconditions.checkNotNull((Object)mimeRulesSource);
        this.componentFactory = (ComponentFactory)Preconditions.checkNotNull((Object)componentFactory);
        this.repositoryMoveStoreProvider = (Provider)Preconditions.checkNotNull(repositoryMoveStoreProvider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        Preconditions.checkArgument((!db.getTransaction().isActive() ? 1 : 0) != 0, (Object)"Nested DB TX!");
    }

    @Nonnull
    public StateGuard getStateGuard() {
        return this.stateGuard;
    }

    @Override
    @Transitions(from={"OPEN"}, to="ACTIVE")
    public void begin() {
        this.db.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    @Override
    @Transitions(from={"ACTIVE"}, to="OPEN", silent=true)
    public void commit() {
        this.db.commit();
        this.blobTx.commit();
        this.retries = 0;
    }

    @Override
    @Transitions(from={"ACTIVE"}, to="OPEN")
    public void rollback() {
        this.db.rollback();
        this.blobTx.rollback();
    }

    public void end() {
        this.blobTx.end();
    }

    public boolean isActive() {
        return "ACTIVE".equals(this.stateGuard.getCurrent());
    }

    public boolean allowRetry(Exception cause) throws RetryDeniedException {
        if (RetryController.INSTANCE.allowRetry(this.retries, cause)) {
            ++this.retries;
            return true;
        }
        throw new RetryDeniedException("Exceeded retry limit", cause);
    }

    public void reason(String reason) {
        this.reason = (String)Preconditions.checkNotNull((Object)reason);
    }

    public String reason() {
        return this.reason;
    }

    @Override
    @Transitions(from={"OPEN", "ACTIVE"}, to="CLOSED")
    public void close() {
        if ("ACTIVE".equals(this.stateGuard.getCurrent())) {
            this.rollback();
        }
        this.db.close();
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public ODatabaseDocumentTx getDb() {
        return this.db;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<ODocument> browse(String selectSql, @Nullable Map<String, Object> params) {
        if (Strings2.isBlank((String)selectSql)) {
            return Collections.emptyList();
        }
        return OrientAsyncHelper.asyncIterable(this.db, selectSql, params);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<ODocument> browse(String selectSql, @Nullable Map<String, Object> params, int bufferSize, long timeoutSeconds) {
        if (Strings2.isBlank((String)selectSql)) {
            return Collections.emptyList();
        }
        return OrientAsyncHelper.asyncIterable(this.db, selectSql, params, bufferSize, timeoutSeconds);
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Bucket findBucket(Repository repository) {
        return this.bucketOf(repository.getName());
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Iterable<Bucket> findBuckets(Iterable<Repository> repositories) {
        return this.bucketsOf(repositories);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Bucket> browseBuckets() {
        return this.bucketEntityAdapter.browse(this.db);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAssets(Bucket bucket) {
        return this.assetEntityAdapter.browseByBucket(this.db, bucket);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAssets(Component component) {
        return this.assetEntityAdapter.browseByComponent(this.db, component);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAssets(Query query, Bucket bucket) {
        return this.assetEntityAdapter.browseByQueryAsync(this.db, query.getWhere(), query.getParameters(), (Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)), query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAllPartiallyByLimit(Bucket bucket) {
        return this.assetEntityAdapter.browseAllPartiallyByLimit(this.db, null, null, (Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)));
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAllPartiallyByLimit(Query query, Bucket bucket) {
        return this.assetEntityAdapter.browseAllPartiallyByLimit(this.db, query.getWhere(), query.getParameters(), (Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)));
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> browseAssets(Query query, Bucket bucket, int bufferSize, int bufferTimeoutSeconds) {
        return this.assetEntityAdapter.browseByQueryAsync(this.db, query.getWhere(), query.getParameters(), (Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)), query.getQuerySuffix(), bufferSize, bufferTimeoutSeconds);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Asset firstAsset(Component component) {
        return (Asset)Iterables.getFirst(this.browseAssets(component), null);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Component> browseComponents(Bucket bucket) {
        return this.componentEntityAdapter.browseByBucket(this.db, bucket);
    }

    @Override
    public Iterable<Component> browseComponents(Query query, Bucket bucket) {
        return this.componentEntityAdapter.browseByQueryAsync(this.db, query.getWhere(), query.getParameters(), (Iterable<Bucket>)ImmutableList.of((Object)((Object)bucket)), query.getQuerySuffix());
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Asset findAsset(EntityId id, Bucket bucket) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)((Object)bucket));
        Asset asset = (Asset)this.assetEntityAdapter.read(this.db, id);
        return this.bucketOwns(bucket, asset) ? asset : null;
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Asset findAsset(EntityId id) {
        Preconditions.checkNotNull((Object)id);
        return (Asset)this.assetEntityAdapter.read(this.db, id);
    }

    private boolean bucketOwns(Bucket bucket, @Nullable MetadataNode<?> item) {
        return item != null && Objects.equals(EntityHelper.id((Entity)bucket), item.bucketId());
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Asset findAssetWithProperty(String propName, Object propValue, Bucket bucket) {
        return (Asset)this.assetEntityAdapter.findByProperty(this.db, propName, propValue, bucket);
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Asset findAssetWithProperty(String propName, Object propValue) {
        return (Asset)this.assetEntityAdapter.findByProperty(this.db, propName, propValue);
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Asset findAssetWithProperty(String propName, Object propValue, Component component) {
        return this.assetEntityAdapter.findByProperty(this.db, propName, propValue, component);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> findAssets(@Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Repository> repositories, @Nullable String querySuffix) {
        return this.assetEntityAdapter.browseByQuery(this.db, whereClause, parameters, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Asset> findAssets(Query query, @Nullable Iterable<Repository> repositories) {
        return this.findAssets(query.getWhere(), query.getParameters(), repositories, query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countAssets(@Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Repository> repositories, @Nullable String querySuffix) {
        return this.assetEntityAdapter.countByQuery(this.db, whereClause, parameters, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countAssets(Query query, @Nullable Iterable<Repository> repositories) {
        return this.countAssets(query.getWhere(), query.getParameters(), repositories, query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countGroupedAssets(@Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Repository> repositories, String querySuffix) {
        Preconditions.checkNotNull((Object)querySuffix);
        Preconditions.checkState((boolean)StringUtils.containsIgnoreCase((CharSequence)querySuffix, (CharSequence)"group by"));
        return this.assetEntityAdapter.countGroupByQuery(this.db, whereClause, parameters, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countGroupedAssets(Query query, @Nullable Iterable<Repository> repositories) {
        return this.countGroupedAssets(query.getWhere(), query.getParameters(), repositories, query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public boolean componentExists(@Nullable String group, String name, @Nullable String version, Repository repository) {
        return this.componentEntityAdapter.exists(this.db, group, name, version, this.bucketOf(repository.getName()));
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public boolean assetExists(String name, Repository repository) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)repository);
        return this.assetEntityAdapter.exists(this.db, name, this.bucketOf(repository.getName()));
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Component findComponentInBucket(EntityId id, Bucket bucket) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)((Object)bucket));
        Component component = this.findComponent(id);
        return this.bucketOwns(bucket, component) ? component : null;
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Component findComponent(EntityId id) {
        Preconditions.checkNotNull((Object)id);
        return (Component)this.componentEntityAdapter.read(this.db, id);
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Component findComponentWithProperty(String propName, Object propValue, Bucket bucket) {
        return (Component)this.componentEntityAdapter.findByProperty(this.db, propName, propValue, bucket);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Component> findComponents(@Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Repository> repositories, @Nullable String querySuffix) {
        return this.componentEntityAdapter.browseByQuery(this.db, whereClause, parameters, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Component> findComponents(Query query, @Nullable Iterable<Repository> repositories) {
        return this.findComponents(query.getWhere(), query.getParameters(), repositories, query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Iterable<Component> findComponentsByNameCaseInsensitive(String name, @Nullable Iterable<Repository> repositories, @Nullable String querySuffix) {
        return this.componentEntityAdapter.browseByNameCaseInsensitive(this.db, name, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countComponents(@Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Repository> repositories, @Nullable String querySuffix) {
        return this.componentEntityAdapter.countByQuery(this.db, whereClause, parameters, this.bucketsOf(repositories), querySuffix);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public long countComponents(Query query, @Nullable Iterable<Repository> repositories) {
        return this.countComponents(query.getWhere(), query.getParameters(), repositories, query.getQuerySuffix());
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Asset createAsset(Bucket bucket, Format format) {
        Preconditions.checkNotNull((Object)format);
        return this.createAsset(bucket, format.toString());
    }

    private Asset createAsset(Bucket bucket, String format) {
        Preconditions.checkNotNull((Object)((Object)bucket));
        Asset asset = new Asset();
        asset.bucketId(EntityHelper.id((Entity)bucket));
        asset.format(format);
        asset.attributes(new NestedAttributesMap("attributes", new HashMap()));
        if (ProxyFacetSupport.isDownloading()) {
            asset.lastDownloaded(DateTime.now());
        }
        return asset;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Asset createAsset(Bucket bucket, Component component) {
        Preconditions.checkNotNull((Object)component);
        Asset asset = this.createAsset(bucket, component.format());
        asset.componentId(EntityHelper.id((Entity)component));
        return asset;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Component createComponent(Bucket bucket, Format format) {
        Preconditions.checkNotNull((Object)((Object)bucket));
        Preconditions.checkNotNull((Object)format);
        Component component = this.componentFactory.createComponent();
        component.bucketId(EntityHelper.id((Entity)bucket));
        component.format(format.toString());
        component.attributes(new NestedAttributesMap("attributes", new HashMap()));
        return component;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void saveBucket(Bucket bucket) {
        this.bucketEntityAdapter.editEntity(this.db, (Entity)bucket);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void saveComponent(Component component) {
        if (EntityHelper.hasMetadata((Entity)component)) {
            this.componentEntityAdapter.editEntity(this.db, component);
        } else {
            this.componentEntityAdapter.addEntity(this.db, component);
        }
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void saveAsset(Asset asset) {
        if (EntityHelper.hasMetadata((Entity)asset)) {
            this.assetEntityAdapter.editEntity(this.db, asset);
        } else {
            this.assetEntityAdapter.addEntity(this.db, asset);
        }
        if (asset.blobRef() != null && asset.blobRef().getBlobId() != null) {
            this.attachAssetMetadata(asset, asset.blobRef().getBlobId());
        }
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Set<String> deleteComponent(Component component) {
        return this.deleteComponent(component, true);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Set<String> deleteComponent(Component component, boolean deleteBlobs) {
        return this.deleteComponent(component, true, deleteBlobs);
    }

    private Set<String> deleteComponent(Component component, boolean checkWritePolicy, boolean deleteBlobs) {
        Preconditions.checkNotNull((Object)component);
        HashSet<String> deletedAssets = new HashSet<String>();
        for (Asset asset : this.browseAssets(component)) {
            this.deleteAsset(asset, checkWritePolicy ? this.writePolicySelector.select(asset, this.writePolicy) : null, deleteBlobs);
            deletedAssets.add(asset.name());
        }
        this.componentEntityAdapter.deleteEntity(this.db, component);
        return deletedAssets;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void deleteAsset(Asset asset) {
        this.deleteAsset(asset, true);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void deleteAsset(Asset asset, boolean deleteBlob) {
        this.deleteAsset(asset, this.writePolicySelector.select(asset, this.writePolicy), deleteBlob);
    }

    private void deleteAsset(Asset asset, @Nullable WritePolicy effectiveWritePolicy, boolean deleteBlob) {
        BlobRef blobRef;
        Preconditions.checkNotNull((Object)asset);
        if (deleteBlob && (blobRef = asset.blobRef()) != null) {
            this.deleteBlob(blobRef, effectiveWritePolicy, String.format("Deleting asset %s", EntityHelper.id((Entity)asset)));
        }
        this.assetEntityAdapter.deleteEntity(this.db, asset);
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public AssetBlob createBlob(String blobName, InputStreamSupplier streamSupplier, Iterable<HashAlgorithm> hashAlgorithms, @Nullable Map<String, String> headers, @Nullable String declaredContentType, boolean skipContentVerification) throws IOException {
        Preconditions.checkNotNull((Object)blobName);
        Preconditions.checkNotNull((Object)streamSupplier);
        Preconditions.checkNotNull(hashAlgorithms);
        if (!this.writePolicy.checkCreateAllowed()) {
            throw new IllegalOperationException("Repository is read only: " + this.repositoryName);
        }
        Map<String, String> storageHeadersMap = this.buildStorageHeaders(blobName, streamSupplier, headers, declaredContentType, skipContentVerification);
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream in = streamSupplier.get();){
            return this.blobTx.create(in, storageHeadersMap, hashAlgorithms, storageHeadersMap.get("BlobStore.content-type"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public AssetBlob createBlob(String blobName, Path sourceFile, Map<HashAlgorithm, HashCode> hashes, @Nullable Map<String, String> headers, String declaredContentType, long size) throws IOException {
        Preconditions.checkNotNull((Object)blobName);
        Preconditions.checkNotNull((Object)sourceFile);
        Preconditions.checkNotNull(hashes);
        Preconditions.checkArgument((!Strings2.isBlank((String)declaredContentType) ? 1 : 0) != 0, (Object)"no declaredContentType provided");
        if (!this.writePolicy.checkCreateAllowed()) {
            throw new IllegalOperationException("Repository is read only: " + this.repositoryName);
        }
        Map<String, String> storageHeaders = this.buildStorageHeaders(blobName, null, headers, declaredContentType, true);
        return this.blobTx.createByHardLinking(sourceFile, storageHeaders, hashes, declaredContentType, size);
    }

    @Override
    public AssetBlob createBlob(String blobName, TempBlob originalBlob, @Nullable Map<String, String> headers, @Nullable String declaredContentType, boolean skipContentVerification) throws IOException {
        Preconditions.checkNotNull((Object)blobName);
        Preconditions.checkNotNull((Object)originalBlob);
        if (!this.writePolicy.checkCreateAllowed()) {
            throw new IllegalOperationException("Repository is read only: " + this.repositoryName);
        }
        Map<String, String> storageHeadersMap = this.buildStorageHeaders(blobName, (InputStreamSupplier)originalBlob, headers, declaredContentType, skipContentVerification);
        try {
            return this.blobTx.createByCopying(originalBlob.getBlobRef(this.nodeAccess.getId()), storageHeadersMap, originalBlob.getHashes(), originalBlob.getHashesVerified());
        }
        catch (MissingBlobException missingBlobException) {
            log.info("Blob {} no longer in blob store, attempting to copy cross-blob store", (Object)originalBlob.getBlobRef(this.nodeAccess.getId()));
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream inputStream = originalBlob.get();){
                return this.blobTx.create(inputStream, storageHeadersMap, originalBlob.getHashes().keySet(), storageHeadersMap.get("BlobStore.content-type"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Map<String, String> buildStorageHeaders(String blobName, @Nullable InputStreamSupplier streamSupplier, @Nullable Map<String, String> headers, @Nullable String declaredContentType, boolean skipContentVerification) throws IOException {
        Preconditions.checkArgument((!skipContentVerification || !Strings2.isBlank((String)declaredContentType) ? 1 : 0) != 0, (Object)"skipContentVerification set true but no declaredContentType provided");
        ImmutableMap.Builder storageHeaders = ImmutableMap.builder();
        storageHeaders.put((Object)"Bucket.repo-name", (Object)this.repositoryName);
        storageHeaders.put((Object)"BlobStore.blob-name", (Object)blobName);
        if (!skipContentVerification) {
            storageHeaders.put((Object)"BlobStore.content-type", (Object)this.determineContentType(streamSupplier, blobName, declaredContentType));
        } else {
            storageHeaders.put((Object)"BlobStore.content-type", (Object)declaredContentType);
        }
        if (headers == null) {
            storageHeaders.put((Object)"BlobStore.created-by", (Object)this.createdBy);
            storageHeaders.put((Object)"BlobStore.created-by-ip", (Object)this.createdByIp);
        } else {
            storageHeaders.putAll(headers);
            if (!headers.containsKey("BlobStore.created-by")) {
                storageHeaders.put((Object)"BlobStore.created-by", (Object)this.createdBy);
            }
            if (!headers.containsKey("BlobStore.created-by-ip")) {
                storageHeaders.put((Object)"BlobStore.created-by-ip", (Object)this.createdByIp);
            }
        }
        return storageHeaders.build();
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void attachBlob(Asset asset, AssetBlob assetBlob) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)assetBlob);
        Preconditions.checkArgument((!assetBlob.isAttached() ? 1 : 0) != 0, (Object)"Blob is already attached to an asset");
        WritePolicy effectiveWritePolicy = this.writePolicySelector.select(asset, this.writePolicy);
        if (!effectiveWritePolicy.checkCreateAllowed()) {
            throw new IllegalOperationException("Repository is read only: " + this.repositoryName);
        }
        NestedAttributesMap checksums = asset.attributes().child("checksum");
        if (!this.isDuplicateBlob(asset, assetBlob, effectiveWritePolicy, checksums)) {
            this.maybeDeleteBlob(asset, assetBlob, effectiveWritePolicy);
            asset.blobRef(assetBlob.getBlobRef());
            asset.size(assetBlob.getSize());
            asset.contentType(assetBlob.getContentType());
            for (Map.Entry<HashAlgorithm, HashCode> entry : assetBlob.getHashes().entrySet()) {
                HashAlgorithm algorithm = entry.getKey();
                HashCode checksum = entry.getValue();
                checksums.set(algorithm.name(), (Object)checksum.toString());
            }
            NestedAttributesMap provenance = asset.attributes().child("provenance");
            provenance.set("hashes_not_verified", (Object)(!assetBlob.getHashesVerified() ? 1 : 0));
            Map blobHeaders = assetBlob.getBlob().getHeaders();
            if (blobHeaders.containsKey("BlobStore.created-by")) {
                asset.createdBy((String)blobHeaders.get("BlobStore.created-by"));
            }
            if (blobHeaders.containsKey("BlobStore.created-by-ip")) {
                asset.createdByIp((String)blobHeaders.get("BlobStore.created-by-ip"));
            }
            assetBlob.setAttached(true);
        }
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public void attachAssetMetadata(Asset asset, BlobId blobId) {
        try {
            NestedAttributesMap componentAttributes = null;
            EntityId componentId = asset.componentId();
            if (componentId != null) {
                Component component = this.findComponent(componentId);
                componentAttributes = component.attributes();
            }
            this.blobTx.attachAssetMetadata(blobId, componentAttributes, asset.attributes());
        }
        catch (Exception e) {
            log.error("Failed to attach asset attributes to blob", (Throwable)e);
        }
    }

    private boolean checksumExists(NestedAttributesMap checksums, AssetBlob assetBlob) {
        if (!checksums.isEmpty()) {
            for (HashAlgorithm algorithm : assetBlob.getHashes().keySet()) {
                if (!checksums.contains(algorithm.name())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareChecksums(NestedAttributesMap checksums, AssetBlob assetBlob) {
        for (Map.Entry<HashAlgorithm, HashCode> entry : assetBlob.getHashes().entrySet()) {
            HashAlgorithm algorithm = entry.getKey();
            HashCode checksum = entry.getValue();
            if (checksum.toString().equals(checksums.get(algorithm.name()))) continue;
            return false;
        }
        return true;
    }

    private boolean isDuplicateBlob(Asset asset, AssetBlob assetBlob, WritePolicy effectiveWritePolicy, NestedAttributesMap checksums) {
        if (asset.blobRef() != null) {
            Blob oldBlob = this.blobTx.get(asset.blobRef());
            if (asset.blobRef().equals((Object)assetBlob.getBlobRef())) {
                assetBlob.setDuplicate(oldBlob);
                return true;
            }
            if (oldBlob != null) {
                boolean checksumsMatch;
                if (assetBlob.getHashesVerified() && this.checksumExists(checksums, assetBlob)) {
                    checksumsMatch = this.compareChecksums(checksums, assetBlob);
                } else {
                    String oldBlobSha1 = oldBlob.getMetrics().getSha1Hash();
                    String newBlobSha1 = assetBlob.getBlob().getMetrics().getSha1Hash();
                    checksumsMatch = oldBlobSha1.equalsIgnoreCase(newBlobSha1);
                }
                if (checksumsMatch) {
                    if (!effectiveWritePolicy.checkUpdateAllowed()) {
                        throw new IllegalOperationException("Repository does not allow updating assets: " + this.repositoryName);
                    }
                    assetBlob.setDuplicate(oldBlob);
                    return true;
                }
            }
        }
        return false;
    }

    private void maybeDeleteBlob(Asset asset, AssetBlob assetBlob, WritePolicy effectiveWritePolicy) {
        DateTime now = DateTime.now();
        if (asset.blobRef() != null) {
            if (!effectiveWritePolicy.checkUpdateAllowed()) {
                throw new IllegalOperationException("Repository does not allow updating assets: " + this.repositoryName);
            }
            asset.blobUpdated(now);
            this.deleteBlob(asset.blobRef(), effectiveWritePolicy, String.format("Updating asset %s", EntityHelper.id((Entity)asset)));
        } else {
            asset.blobCreated(now);
            asset.blobUpdated(now);
        }
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public AssetBlob setBlob(Asset asset, String blobName, InputStreamSupplier streamSupplier, Iterable<HashAlgorithm> hashAlgorithms, @Nullable Map<String, String> headers, @Nullable String declaredContentType, boolean skipContentVerification) throws IOException {
        Preconditions.checkNotNull((Object)asset);
        BlobRef oldBlobRef = asset.blobRef();
        if (oldBlobRef != null && !this.writePolicySelector.select(asset, this.writePolicy).checkUpdateAllowed()) {
            throw new IllegalOperationException("Repository does not allow updating assets: " + this.repositoryName);
        }
        AssetBlob assetBlob = this.createBlob(blobName, streamSupplier, hashAlgorithms, headers, declaredContentType, skipContentVerification);
        this.attachBlob(asset, assetBlob);
        return assetBlob;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public AssetBlob setBlob(Asset asset, String blobName, Path sourceFile, Map<HashAlgorithm, HashCode> hashes, @Nullable Map<String, String> headers, String declaredContentType, long size) throws IOException {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkArgument((!Strings2.isBlank((String)declaredContentType) ? 1 : 0) != 0, (Object)"no declaredContentType provided");
        BlobRef oldBlobRef = asset.blobRef();
        if (oldBlobRef != null && !this.writePolicySelector.select(asset, this.writePolicy).checkUpdateAllowed()) {
            throw new IllegalOperationException("Repository does not allow updating assets: " + this.repositoryName);
        }
        AssetBlob assetBlob = this.createBlob(blobName, sourceFile, hashes, headers, declaredContentType, size);
        this.attachBlob(asset, assetBlob);
        return assetBlob;
    }

    @Override
    public AssetBlob setBlob(Asset asset, String blobName, TempBlob originalBlob, @Nullable Map<String, String> headers, @Nullable String declaredContentType, boolean skipContentVerification) throws IOException {
        Preconditions.checkNotNull((Object)blobName);
        Preconditions.checkNotNull((Object)originalBlob);
        BlobRef oldBlobRef = asset.blobRef();
        if (oldBlobRef != null && !this.writePolicySelector.select(asset, this.writePolicy).checkUpdateAllowed()) {
            throw new IllegalOperationException("Repository does not allow updating assets: " + this.repositoryName);
        }
        AssetBlob assetBlob = this.createBlob(blobName, originalBlob, headers, declaredContentType, skipContentVerification);
        this.attachBlob(asset, assetBlob);
        return assetBlob;
    }

    @Override
    @Nullable
    @Guarded(by={"ACTIVE"})
    public Blob getBlob(BlobRef blobRef) {
        Preconditions.checkNotNull((Object)blobRef);
        Blob blob = this.blobTx.get(blobRef);
        if (blob == null && this.repositoryMoveStoreProvider.get() != null) {
            blob = ((RepositoryMoveService)this.repositoryMoveStoreProvider.get()).getIfBeingMoved(blobRef, this.repositoryName);
        }
        return blob;
    }

    @Override
    @Guarded(by={"ACTIVE"})
    public Blob requireBlob(BlobRef blobRef) {
        Blob blob = this.getBlob(blobRef);
        if (blob == null) {
            throw new MissingBlobException(blobRef);
        }
        return blob;
    }

    @Nonnull
    private String determineContentType(InputStreamSupplier inputStreamSupplier, String blobName, @Nullable String declaredContentType) throws IOException {
        try {
            return this.contentValidator.determineContentType(this.strictContentValidation, inputStreamSupplier, this.mimeRulesSource, blobName, declaredContentType);
        }
        catch (InvalidContentException e) {
            log.warn("An exception occurred determining the content type of asset {} in repository {}", (Object)blobName, (Object)this.repositoryName);
            throw e;
        }
    }

    private void deleteBlob(BlobRef blobRef, @Nullable WritePolicy effectiveWritePolicy, String reason) {
        Preconditions.checkNotNull((Object)blobRef);
        if (effectiveWritePolicy != null && !effectiveWritePolicy.checkDeleteAllowed()) {
            throw new IllegalOperationException("Repository does not allow deleting assets: " + this.repositoryName);
        }
        this.blobTx.delete(blobRef, reason);
    }

    @Nullable
    private Bucket bucketOf(String repositoryName) {
        return this.bucketEntityAdapter.read(this.db, repositoryName);
    }

    @Nullable
    private Iterable<Bucket> bucketsOf(@Nullable Iterable<Repository> repositories) {
        if (repositories == null) {
            return null;
        }
        ImmutableList.Builder bucketsBuilder = ImmutableList.builder();
        for (Repository repository : repositories) {
            bucketsBuilder.add((Object)this.bucketOf(repository.getName()));
        }
        return bucketsBuilder.build();
    }

    public static final class State {
        public static final String OPEN = "OPEN";
        public static final String ACTIVE = "ACTIVE";
        public static final String CLOSED = "CLOSED";
    }
}

