/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.TransactionalSession;

public interface StorageTx
extends TransactionalSession<StorageTx>,
Transaction {
    public void begin();

    public void commit();

    public void rollback();

    public void close();

    public ODatabaseDocumentTx getDb();

    public Iterable<ODocument> browse(String var1, @Nullable Map<String, Object> var2);

    public Iterable<ODocument> browse(String var1, @Nullable Map<String, Object> var2, int var3, long var4);

    @Nullable
    public Bucket findBucket(Repository var1);

    @Nullable
    public Iterable<Bucket> findBuckets(Iterable<Repository> var1);

    public Iterable<Bucket> browseBuckets();

    public Iterable<Asset> browseAssets(Bucket var1);

    public Iterable<Asset> browseAssets(Query var1, Bucket var2);

    public Iterable<Asset> browseAllPartiallyByLimit(Bucket var1);

    public Iterable<Asset> browseAllPartiallyByLimit(Query var1, Bucket var2);

    public Iterable<Asset> browseAssets(Query var1, Bucket var2, int var3, int var4);

    public Iterable<Asset> browseAssets(Component var1);

    @Nullable
    public Asset firstAsset(Component var1);

    public Iterable<Component> browseComponents(Query var1, Bucket var2);

    public Iterable<Component> browseComponents(Bucket var1);

    @Nullable
    public Asset findAsset(EntityId var1, Bucket var2);

    @Nullable
    public Asset findAsset(EntityId var1);

    @Nullable
    public Asset findAssetWithProperty(String var1, Object var2, Bucket var3);

    @Nullable
    public Asset findAssetWithProperty(String var1, Object var2);

    @Nullable
    public Asset findAssetWithProperty(String var1, Object var2, Component var3);

    public Iterable<Asset> findAssets(@Nullable String var1, @Nullable Map<String, Object> var2, @Nullable Iterable<Repository> var3, @Nullable String var4);

    public Iterable<Asset> findAssets(Query var1, @Nullable Iterable<Repository> var2);

    public long countAssets(@Nullable String var1, @Nullable Map<String, Object> var2, @Nullable Iterable<Repository> var3, @Nullable String var4);

    public long countAssets(Query var1, @Nullable Iterable<Repository> var2);

    public boolean componentExists(@Nullable String var1, String var2, @Nullable String var3, Repository var4);

    public long countGroupedAssets(@Nullable String var1, @Nullable Map<String, Object> var2, @Nullable Iterable<Repository> var3, String var4);

    public long countGroupedAssets(Query var1, @Nullable Iterable<Repository> var2);

    public boolean assetExists(String var1, Repository var2);

    @Nullable
    public Component findComponentInBucket(EntityId var1, Bucket var2);

    @Nullable
    public Component findComponent(EntityId var1);

    @Nullable
    public Component findComponentWithProperty(String var1, Object var2, Bucket var3);

    public Iterable<Component> findComponents(@Nullable String var1, @Nullable Map<String, Object> var2, @Nullable Iterable<Repository> var3, @Nullable String var4);

    public Iterable<Component> findComponents(Query var1, @Nullable Iterable<Repository> var2);

    public Iterable<Component> findComponentsByNameCaseInsensitive(String var1, @Nullable Iterable<Repository> var2, @Nullable String var3);

    public long countComponents(@Nullable String var1, @Nullable Map<String, Object> var2, @Nullable Iterable<Repository> var3, @Nullable String var4);

    public long countComponents(Query var1, @Nullable Iterable<Repository> var2);

    public Asset createAsset(Bucket var1, Format var2);

    public Asset createAsset(Bucket var1, Component var2);

    public Component createComponent(Bucket var1, Format var2);

    public void saveBucket(Bucket var1);

    public void saveComponent(Component var1);

    public void saveAsset(Asset var1);

    public Set<String> deleteComponent(Component var1);

    public Set<String> deleteComponent(Component var1, boolean var2);

    public void deleteAsset(Asset var1);

    public void deleteAsset(Asset var1, boolean var2);

    public AssetBlob setBlob(Asset var1, String var2, InputStreamSupplier var3, Iterable<HashAlgorithm> var4, @Nullable Map<String, String> var5, @Nullable String var6, boolean var7) throws IOException;

    public AssetBlob setBlob(Asset var1, String var2, Path var3, Map<HashAlgorithm, HashCode> var4, @Nullable Map<String, String> var5, String var6, long var7) throws IOException;

    public AssetBlob setBlob(Asset var1, String var2, TempBlob var3, @Nullable Map<String, String> var4, @Nullable String var5, boolean var6) throws IOException;

    public AssetBlob createBlob(String var1, InputStreamSupplier var2, Iterable<HashAlgorithm> var3, @Nullable Map<String, String> var4, @Nullable String var5, boolean var6) throws IOException;

    public AssetBlob createBlob(String var1, Path var2, Map<HashAlgorithm, HashCode> var3, @Nullable Map<String, String> var4, String var5, long var6) throws IOException;

    public AssetBlob createBlob(String var1, TempBlob var2, @Nullable Map<String, String> var3, @Nullable String var4, boolean var5) throws IOException;

    public void attachBlob(Asset var1, AssetBlob var2);

    public void attachAssetMetadata(Asset var1, BlobId var2);

    @Nullable
    public Blob getBlob(BlobRef var1);

    public Blob requireBlob(BlobRef var1);

    default public StorageTx getTransaction() {
        return this;
    }
}

