/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import java.util.Collections;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class SingleAssetComponentMaintenance
extends DefaultComponentMaintenanceImpl {
    @Override
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        EntityId componentId = asset.componentId();
        if (componentId == null) {
            return super.deleteAssetTx(assetId, deleteBlob);
        }
        return this.deleteComponentTx(componentId, deleteBlob).getAssets();
    }
}

