/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class RebuildAssetUploadMetadataTaskManager
extends LifecycleSupport {
    private final TaskScheduler taskScheduler;

    @Inject
    public RebuildAssetUploadMetadataTaskManager(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() {
        this.removeOldRebuildTasks();
    }

    private void removeOldRebuildTasks() {
        this.taskScheduler.listsTasks().stream().filter(task -> "rebuild.asset.uploadMetadata".equals(task.getConfiguration().getTypeId())).forEach(TaskInfo::remove);
    }
}

