/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.StorageTx;

@Deprecated
@Named
@Singleton
public class OrientHardLinkHelper {
    private final MimeSupport mimeSupport;

    @Inject
    public OrientHardLinkHelper(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    public AssetBlob ingestHardLink(StorageTx tx, File content, Map<HashAlgorithm, HashCode> hashes) throws IOException {
        Preconditions.checkState((boolean)hashes.containsKey(HashAlgorithm.SHA1));
        String path = content.getPath();
        Path contentPath = content.toPath();
        String contentType = this.detectMimeType(content);
        long size = Files.size(contentPath);
        return tx.createBlob(path, contentPath, hashes, null, contentType, size);
    }

    public AssetBlob ingestHardLink(StorageTx tx, File content, Map<HashAlgorithm, HashCode> hashes, String contentType) throws IOException {
        Preconditions.checkState((boolean)hashes.containsKey(HashAlgorithm.SHA1));
        String path = content.getPath();
        Path contentPath = content.toPath();
        long size = Files.size(contentPath);
        return tx.createBlob(path, contentPath, hashes, null, contentType, size);
    }

    private String detectMimeType(File content) throws IOException {
        String path = content.getPath();
        Path contentPath = content.toPath();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(contentPath, new OpenOption[0]));){
            return this.mimeSupport.detectMimeType((InputStream)inputStream, path);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

