/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.Repository;

@Singleton
@Named
public class MimeRulesSourceSelector
extends ComponentSupport {
    private final Map<String, MimeRulesSource> mimeRulesSources;

    @Inject
    public MimeRulesSourceSelector(Map<String, MimeRulesSource> mimeRulesSources) {
        this.mimeRulesSources = (Map)Preconditions.checkNotNull(mimeRulesSources);
    }

    @Nonnull
    public MimeRulesSource ruleSource(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        this.log.trace("Looking for MIME rule source for format: {}", (Object)format);
        MimeRulesSource mimeRulesSource = this.mimeRulesSources.get(format);
        if (mimeRulesSource != null) {
            return mimeRulesSource;
        }
        return MimeRulesSource.NOOP;
    }
}

