/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.MetadataNode;
import org.sonatype.nexus.repository.storage.OrientAsyncHelper;

public abstract class MetadataNodeEntityAdapter<T extends MetadataNode<?>>
extends IterableEntityAdapter<T> {
    public static final String P_ATTRIBUTES = "attributes";
    public static final String P_BUCKET = "bucket";
    public static final String P_FORMAT = "format";
    public static final String P_NAME = "name";
    static final String P_LAST_UPDATED = "last_updated";
    private static final String RID = "rid";
    private static final String START_RID = "#-1:-1";
    private static final String SKIP_AS_QUERY_IS_EMPTY = "Skipped finding {}s as query is empty, parameters: {}";
    protected final BucketEntityAdapter bucketEntityAdapter;

    public MetadataNodeEntityAdapter(String typeName, BucketEntityAdapter bucketEntityAdapter) {
        super(typeName);
        this.bucketEntityAdapter = bucketEntityAdapter;
    }

    protected void defineType(OClass type) {
        type.createProperty(P_BUCKET, OType.LINK, this.bucketEntityAdapter.getSchemaType()).setMandatory(true).setNotNull(true);
        type.createProperty(P_FORMAT, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_LAST_UPDATED, OType.DATETIME);
        type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP);
    }

    protected void readFields(ODocument document, T entity) {
        ORID bucketId = (ORID)document.field(P_BUCKET, ORID.class);
        String format = (String)document.field(P_FORMAT, OType.STRING);
        Date lastUpdated = (Date)document.field(P_LAST_UPDATED, OType.DATETIME);
        Map attributes = (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        entity.bucketId((EntityId)new AttachedEntityId((EntityAdapter)this.bucketEntityAdapter, bucketId));
        entity.format(format);
        entity.lastUpdated(new DateTime((Object)lastUpdated));
        entity.attributes(new NestedAttributesMap(P_ATTRIBUTES, this.detachable(attributes)));
        entity.newEntity(document.getIdentity().isNew());
    }

    protected void writeFields(ODocument document, T entity) {
        document.field(P_BUCKET, (Object)this.bucketEntityAdapter.recordIdentity(entity.bucketId()));
        document.field(P_FORMAT, (Object)entity.format());
        document.field(P_LAST_UPDATED, (Object)new Date());
        document.field(P_ATTRIBUTES, (Object)entity.attributes().backing());
    }

    Iterable<T> browseByBucket(ODatabaseDocumentTx db, Bucket bucket) {
        Preconditions.checkNotNull((Object)((Object)bucket));
        Preconditions.checkState((boolean)EntityHelper.hasMetadata((Entity)bucket));
        ImmutableMap parameters = ImmutableMap.of((Object)P_BUCKET, (Object)this.bucketEntityAdapter.recordIdentity((Entity)bucket));
        String query = String.format("select from %s where %s = :bucket", this.getTypeName(), P_BUCKET);
        Iterable<ODocument> docs = OrientAsyncHelper.asyncIterable(db, query, (Map<String, Object>)parameters);
        return this.transform(docs);
    }

    T findByProperty(ODatabaseDocumentTx db, String propName, Object propValue, Bucket bucket) {
        Preconditions.checkNotNull((Object)propName);
        Preconditions.checkNotNull((Object)propValue);
        Preconditions.checkNotNull((Object)((Object)bucket));
        ImmutableMap parameters = ImmutableMap.of((Object)P_BUCKET, (Object)this.bucketEntityAdapter.recordIdentity((Entity)bucket), (Object)"propValue", (Object)propValue);
        String query = String.format("select from %s where %s = :bucket and %s = :propValue", this.getTypeName(), P_BUCKET, propName);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        ODocument first = (ODocument)Iterables.getFirst((Iterable)docs, null);
        return (T)(first != null ? (MetadataNode)this.readEntity((OIdentifiable)first) : null);
    }

    T findByProperty(ODatabaseDocumentTx db, String propName, Object propValue) {
        Preconditions.checkNotNull((Object)propName);
        Preconditions.checkNotNull((Object)propValue);
        ImmutableMap parameters = ImmutableMap.of((Object)"propValue", (Object)propValue);
        String query = String.format("select from %s where %s = :propValue", this.getTypeName(), propName);
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        ODocument first = (ODocument)Iterables.getFirst((Iterable)docs, null);
        return (T)(first != null ? (MetadataNode)this.readEntity((OIdentifiable)first) : null);
    }

    Iterable<T> browseByQuery(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix) {
        return this.browseByQuery(db, whereClause, parameters, buckets, querySuffix, false);
    }

    Iterable<T> browseByQueryAsync(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix) {
        return this.browseByQuery(db, whereClause, parameters, buckets, querySuffix, true);
    }

    Iterable<T> browseByQueryAsync(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix, int bufferSize, int bufferTimeoutSeconds) {
        return this.browseByQuery(db, whereClause, parameters, buckets, querySuffix, true, bufferSize, bufferTimeoutSeconds);
    }

    private Iterable<T> browseByQuery(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix, boolean async) {
        String query = this.buildQuery(false, whereClause, buckets, querySuffix);
        if (Strings2.isBlank((String)query)) {
            this.log.debug(SKIP_AS_QUERY_IS_EMPTY, (Object)this.getTypeName(), parameters);
            return Collections.emptyList();
        }
        this.log.debug("Finding {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        if (async) {
            return this.transform(OrientAsyncHelper.asyncIterable(db, query, parameters));
        }
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        return this.transform(docs);
    }

    Iterable<T> browseAllPartiallyByLimit(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets) {
        String querySuffix;
        String query;
        if (parameters != null && parameters.containsKey(RID)) {
            throw new IllegalArgumentException("Using 'rid' is unsupported.");
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (parameters != null) {
            queryParams.putAll(parameters);
        }
        if (Strings2.isBlank((String)(query = this.buildQuery(false, whereClause, buckets, querySuffix = " and @rid > :rid order by @rid LIMIT " + Continuations.BROWSE_LIMIT)))) {
            this.log.debug(SKIP_AS_QUERY_IS_EMPTY, (Object)this.getTypeName(), parameters);
            return Collections.emptySet();
        }
        return Continuations.iterableOf((limit, token) -> {
            this.log.debug("Finding {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
            String rid = token == null ? START_RID : this.recordIdentity((EntityId)new DetachedEntityId(token)).toString();
            queryParams.put(RID, rid);
            Iterable docs = this.transform((Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{queryParams}));
            ContinuationArrayList continuation = new ContinuationArrayList();
            docs.forEach(continuation::add);
            return continuation;
        });
    }

    private Iterable<T> browseByQuery(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix, boolean async, int bufferSize, int bufferTimeoutSeconds) {
        String query = this.buildQuery(false, whereClause, buckets, querySuffix);
        if (Strings2.isBlank((String)query)) {
            this.log.debug(SKIP_AS_QUERY_IS_EMPTY, (Object)this.getTypeName(), parameters);
            return Collections.emptyList();
        }
        this.log.debug("Finding {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        if (async) {
            return this.transform(OrientAsyncHelper.asyncIterable(db, query, parameters, bufferSize, bufferTimeoutSeconds));
        }
        Iterable docs = (Iterable)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        return this.transform(docs);
    }

    long countByQuery(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix) {
        String query = this.buildQuery(true, whereClause, buckets, querySuffix);
        if (Strings2.isBlank((String)query)) {
            this.log.debug("Skipped counting {}s as query is empty, parameters: {}", (Object)this.getTypeName(), parameters);
            return 0L;
        }
        this.log.debug("Counting {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        List results = (List)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        return (Long)((ODocument)results.get(0)).field("count");
    }

    long countGroupByQuery(ODatabaseDocumentTx db, @Nullable String whereClause, @Nullable Map<String, Object> parameters, @Nullable Iterable<Bucket> buckets, String querySuffix) {
        Preconditions.checkNotNull((Object)querySuffix);
        Preconditions.checkState((boolean)StringUtils.containsIgnoreCase((CharSequence)querySuffix, (CharSequence)"group by"));
        String query = this.buildQuery(true, whereClause, buckets, querySuffix);
        if (Strings2.isBlank((String)query)) {
            this.log.debug("Skipped counting {}s as query is empty, parameters: {}", (Object)this.getTypeName(), parameters);
            return 0L;
        }
        query = "select count(*) from (" + this.buildQuery(true, whereClause, buckets, querySuffix) + ")";
        this.log.debug("Counting {}s with grouped by query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        List results = (List)db.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{parameters});
        return (Long)((ODocument)results.get(0)).field("count");
    }

    private String buildQuery(boolean isCount, @Nullable String whereClause, @Nullable Iterable<Bucket> buckets, @Nullable String querySuffix) {
        if (buckets != null && Iterables.isEmpty(buckets)) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        query.append("select");
        if (isCount) {
            query.append(" count(*)");
        }
        query.append(" from ").append(this.getTypeName());
        if (whereClause != null) {
            query.append(" where (").append(whereClause).append(")");
        }
        this.addBucketConstraints(whereClause, buckets, query);
        if (querySuffix != null) {
            query.append(" ").append(querySuffix);
        }
        return query.toString();
    }

    protected void addBucketConstraints(@Nullable String whereClause, @Nullable Iterable<Bucket> buckets, StringBuilder query) {
        if (buckets != null && !Iterables.isEmpty(buckets)) {
            if (whereClause == null) {
                query.append(" where ");
            } else {
                query.append(" and ");
            }
            query.append('(');
            Joiner.on((String)" or ").appendTo(query, Iterables.transform(buckets, bucket -> String.format("%s=%s", P_BUCKET, this.bucketEntityAdapter.recordIdentity((Entity)bucket).toString())));
            query.append(')');
        }
    }

    private static class ContinuationArrayList<T extends MetadataNode<?>>
    extends ArrayList<T>
    implements Continuation<T> {
        private static final long serialVersionUID = -8278643802740770499L;

        private ContinuationArrayList() {
        }

        public String nextContinuationToken() {
            Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"No more results");
            return EntityHelper.id((Entity)((Entity)this.get(this.size() - 1))).getValue();
        }
    }
}

