/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetManager;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="default")
@Singleton
public class LastDownloadedHandler
extends ComponentSupport
implements org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler {
    private final AssetManager assetManager;

    @Inject
    public LastDownloadedHandler(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        try {
            if (this.isSuccessfulRequestWithContent(context, response)) {
                Content content = (Content)response.getPayload();
                this.maybeUpdateLastDownloaded(content.getAttributes());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to update last downloaded time for request {}", (Object)context.getRequest().getPath(), (Object)e);
        }
        return response;
    }

    protected void maybeUpdateLastDownloaded(AttributesMap attributes) {
        this.maybeUpdateLastDownloaded((Asset)attributes.get(Asset.class));
    }

    protected void maybeUpdateLastDownloaded(@Nullable Asset asset) {
        if (asset != null && this.assetManager.maybeUpdateLastDownloaded(asset)) {
            ReplicationModeOverrides.dontWaitForReplicationResults();
            try {
                this.tryPersistLastDownloadedTime(asset);
            }
            finally {
                ReplicationModeOverrides.clearReplicationModeOverrides();
            }
        }
    }

    @Transactional(swallow={ORecordNotFoundException.class, ONeedRetryException.class, OModificationOperationProhibitedException.class})
    @VisibleForTesting
    protected void tryPersistLastDownloadedTime(Asset asset) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset latestAsset = tx.findAsset(EntityHelper.id((Entity)asset));
        if (latestAsset != null && this.assetManager.maybeUpdateLastDownloaded(latestAsset)) {
            tx.saveAsset(latestAsset);
        }
    }

    private boolean isSuccessfulRequestWithContent(Context context, Response response) {
        return this.isGetOrHeadRequest(context) && this.isSuccessfulOrNotModified(response) && response.getPayload() != null && response.getPayload() instanceof Content;
    }

    private boolean isSuccessfulOrNotModified(Response response) {
        return response.getStatus().isSuccessful() || response.getStatus().getCode() == 304;
    }

    private boolean isGetOrHeadRequest(Context context) {
        String action = context.getRequest().getAction();
        return "GET".equals(action) || "HEAD".equals(action);
    }
}

