/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DefaultComponentMaintenanceImpl
extends FacetSupport
implements ComponentMaintenance {
    @Override
    public Set<String> deleteComponent(EntityId componentId) {
        return this.deleteComponent(componentId, true);
    }

    @Override
    public Set<String> deleteComponent(EntityId componentId, boolean deleteBlobs) {
        Preconditions.checkNotNull((Object)componentId);
        UnitOfWork.begin(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Set<String> set = this.deleteComponentTx(componentId, deleteBlobs).getAssets();
            return set;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return new DeletionResult(null, Collections.emptySet());
        }
        this.log.debug("Deleting component: {}", (Object)component.toStringExternal());
        return new DeletionResult(component, tx.deleteComponent(component, deleteBlobs));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> deleteAsset(EntityId assetId) {
        return this.deleteAsset(assetId, true);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> deleteAsset(EntityId assetId, boolean deleteBlob) {
        Preconditions.checkNotNull((Object)assetId);
        UnitOfWork.begin(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Set<String> set = this.deleteAssetTx(assetId, deleteBlob);
            return set;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public DeletionProgress deleteComponents(Iterable<EntityId> components, BooleanSupplier cancelledCheck, int batchSize) {
        Preconditions.checkNotNull(components);
        Preconditions.checkNotNull((Object)cancelledCheck);
        UnitOfWork.beginBatch(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        DeletionProgress deletionProgress = new DeletionProgress();
        try {
            Iterable split = Iterables.partition(components, (int)batchSize);
            for (List entityIds : split) {
                if (cancelledCheck.getAsBoolean()) {
                } else {
                    DeletionProgress batchDeletion = this.doBatchDelete(entityIds, cancelledCheck);
                    deletionProgress.addCount(batchDeletion.getCount());
                    if (!batchDeletion.isFailed()) continue;
                    deletionProgress.setFailed(true);
                }
                break;
            }
        }
        finally {
            UnitOfWork.end();
        }
        this.tryAfter();
        return deletionProgress;
    }

    private void tryAfter() {
        try {
            this.after();
        }
        catch (Exception e) {
            this.log.debug("Unable to run post-cleanup tasks. This could result in missing or incorrect metadata", (Throwable)e);
        }
    }

    @TransactionalDeleteBlob
    protected DeletionProgress deleteComponentBatch(Iterable<EntityId> components, BooleanSupplier cancelledCheck) {
        DeletionProgress deletionProgress = new DeletionProgress();
        try {
            for (EntityId component : components) {
                if (cancelledCheck.getAsBoolean()) continue;
                try {
                    DeletionResult deletionResult = this.deleteComponentTx(component, true);
                    if (deletionResult.getComponent() == null) continue;
                    deletionProgress.addCount(1L);
                    this.log.info("Deleted component with ID '{}', Attributes '{}' and Assets '{}' from repository {}", new Object[]{component, deletionResult.getComponent().toStringExternal(), deletionResult.getAssets(), this.getRepository()});
                }
                catch (Exception e) {
                    this.log.debug("Unable to delete component with ID {}", (Object)component, (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to delete current batch", (Throwable)e);
            deletionProgress.setFailed(true);
        }
        return deletionProgress;
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        this.log.info("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        return Collections.singleton(asset.name());
    }

    protected DeletionProgress doBatchDelete(List<EntityId> entityIds, BooleanSupplier cancelledCheck) {
        return this.deleteComponentBatch(entityIds, cancelledCheck);
    }

    @Override
    public void after() {
    }

    public static class DeletionProgress
    extends org.sonatype.nexus.repository.task.DeletionProgress {
        public DeletionProgress() {
        }

        public DeletionProgress(int retryLimit) {
            super(retryLimit);
        }
    }

    protected static class DeletionResult {
        @Nullable
        private final Component component;
        private final Set<String> assets;

        public DeletionResult(@Nullable Component component, Set<String> assets) {
            this.component = component;
            this.assets = (Set)Preconditions.checkNotNull(assets);
        }

        @Nullable
        public Component getComponent() {
            return this.component;
        }

        public Set<String> getAssets() {
            return this.assets;
        }
    }
}

