/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.DeconflictStepSupport;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class DeconflictAssetMetadata
extends DeconflictStepSupport<Asset> {
    private static final String CACHE_ATTRIBUTES = "attributes.cache";
    private static final String CACHE_TOKEN_ATTRIBUTE = "attributes.cache.cache_token";
    private static final String CACHE_TOKEN_INVALIDATED = "invalidated";
    private static final String LAST_VERIFIED_ATTRIBUTE = "attributes.cache.last_verified";
    private static final String CONTENT_ATTRIBUTES = "attributes.content";
    private static final String LAST_MODIFIED_ATTRIBUTE = "attributes.content.last_modified";

    public ConflictState deconflict(ODocument storedRecord, ODocument changeRecord) {
        return DeconflictAssetMetadata.resolveCache(storedRecord, changeRecord).andThen(() -> DeconflictAssetMetadata.resolveContent(storedRecord, changeRecord).andThen(() -> DeconflictAssetMetadata.pickLatest((ODocument)storedRecord, (ODocument)changeRecord, (String)"last_downloaded").andThen(() -> DeconflictAssetMetadata.pickLatest((ODocument)storedRecord, (ODocument)changeRecord, (String)"last_updated"))));
    }

    public static ConflictState resolveCache(ODocument storedRecord, ODocument changeRecord) {
        Object storedCache = storedRecord.rawField(CACHE_ATTRIBUTES);
        Object changeCache = changeRecord.rawField(CACHE_ATTRIBUTES);
        if (storedCache != null && changeCache != null) {
            return DeconflictAssetMetadata.resolveCacheToken(storedRecord, changeRecord).andThen(() -> DeconflictAssetMetadata.pickLatest((ODocument)storedRecord, (ODocument)changeRecord, (String)LAST_VERIFIED_ATTRIBUTE));
        }
        if (changeCache != null) {
            storedRecord.field(CACHE_ATTRIBUTES, changeCache);
            return ConflictState.ALLOW;
        }
        if (storedCache != null) {
            changeRecord.field(CACHE_ATTRIBUTES, storedCache);
            return ConflictState.MERGE;
        }
        return ConflictState.IGNORE;
    }

    private static ConflictState resolveCacheToken(ODocument storedRecord, ODocument changeRecord) {
        Object changeToken;
        Object storedToken = storedRecord.rawField(CACHE_TOKEN_ATTRIBUTE);
        if (Objects.equals(storedToken, changeToken = changeRecord.rawField(CACHE_TOKEN_ATTRIBUTE))) {
            return ConflictState.IGNORE;
        }
        if (storedToken == null || CACHE_TOKEN_INVALIDATED.equals(changeToken)) {
            storedRecord.field(CACHE_TOKEN_ATTRIBUTE, changeToken);
            return ConflictState.ALLOW;
        }
        if (changeToken == null || CACHE_TOKEN_INVALIDATED.equals(storedToken)) {
            changeRecord.field(CACHE_TOKEN_ATTRIBUTE, storedToken);
            return ConflictState.MERGE;
        }
        return ConflictState.DENY;
    }

    public static ConflictState resolveContent(ODocument storedRecord, ODocument changeRecord) {
        Object storedContent = storedRecord.rawField(CONTENT_ATTRIBUTES);
        Object changeContent = changeRecord.rawField(CONTENT_ATTRIBUTES);
        if (storedContent != null && changeContent != null) {
            return DeconflictAssetMetadata.pickLatest((ODocument)storedRecord, (ODocument)changeRecord, (String)LAST_MODIFIED_ATTRIBUTE);
        }
        if (changeContent != null) {
            storedRecord.field(CONTENT_ATTRIBUTES, changeContent);
            return ConflictState.ALLOW;
        }
        if (storedContent != null) {
            changeRecord.field(CONTENT_ATTRIBUTES, storedContent);
            return ConflictState.MERGE;
        }
        return ConflictState.IGNORE;
    }
}

