/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.selector.SelectorFactory;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class ContentSelectorUpgradeManager
extends StateGuardLifecycleSupport {
    private final SelectorFactory selectorFactory;
    private final SelectorManager selectorManager;

    @Inject
    public ContentSelectorUpgradeManager(SelectorFactory selectorFactory, SelectorManager selectorManager) {
        this.selectorFactory = (SelectorFactory)Preconditions.checkNotNull((Object)selectorFactory);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
    }

    protected void doStart() throws Exception {
        this.selectorManager.browseJexl().forEach(config -> {
            String expression = (String)config.getAttributes().get("expression");
            String name = config.getName();
            this.log.debug("Attempting to upgrade JEXL content selector {} to CSEL, expression={}", (Object)name, (Object)expression);
            try {
                this.selectorFactory.validateSelector("csel", expression);
                config.setType("csel");
                this.selectorManager.update(config);
            }
            catch (Exception e) {
                this.log.warn("Could not upgrade JEXL content selector {} to CSEL, expression={}", new Object[]{name, expression, this.log.isDebugEnabled() ? e : null});
            }
        });
    }
}

