/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentStore;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Named
public class ComponentStoreImpl
extends StateGuardLifecycleSupport
implements ComponentStore,
Lifecycle {
    private final Provider<DatabaseInstance> databaseInstance;
    private final ComponentEntityAdapter entityAdapter;

    @Inject
    public ComponentStoreImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstance, ComponentEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Component read(EntityId id) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return (Component)this.entityAdapter.read(db, id);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Component> getAllMatchingComponents(Repository repository, String group, String name, Map<String, String> formatAttributes) {
        ImmutableList filteredComponents;
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(formatAttributes);
        Throwable throwable = null;
        Object var7_7 = null;
        try (StorageTx storageTx = ((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();){
            storageTx.begin();
            Query.Builder query = Query.builder().where("group").eq(group).and("name").eq(name).suffix("order by version desc");
            Iterable<Component> unfilteredComponents = storageTx.findComponents(query.build(), Collections.singletonList(repository));
            Stream<Component> filteredStream = StreamSupport.stream(unfilteredComponents.spliterator(), false).filter(component -> formatAttributes.entrySet().stream().allMatch(entry -> Objects.equals(entry.getValue(), component.formatAttributes().get((String)entry.getKey()))));
            filteredComponents = ImmutableList.copyOf(filteredStream.iterator());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return filteredComponents;
    }

    @Override
    @Guarded(by={"STARTED"})
    public long countComponents(@Nullable Iterable<Bucket> buckets) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return this.entityAdapter.countByQuery(db, null, null, buckets, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public OIndex<?> getIndex(String indexName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return db.getMetadata().getIndexManager().getIndex(indexName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> List<Map.Entry<T, EntityId>> getNextPage(OIndexCursor cursor, int limit) {
        ArrayList<Map.Entry<T, EntityId>> page = new ArrayList<Map.Entry<T, EntityId>>(limit);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            cursor.setPrefetchSize(limit);
            while (page.size() < limit) {
                Map.Entry entry = cursor.nextEntry();
                if (entry == null) {
                    break;
                }
                Object key = entry.getKey();
                AttachedEntityId value = new AttachedEntityId((EntityAdapter)this.entityAdapter, ((OIdentifiable)entry.getValue()).getIdentity());
                page.add(new AbstractMap.SimpleEntry(key, value));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return page;
    }
}

