/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.internal.BucketCreatedEvent;
import org.sonatype.nexus.repository.storage.internal.BucketDeletedEvent;
import org.sonatype.nexus.repository.storage.internal.BucketUpdatedEvent;

@Named
@Singleton
public class BucketEntityAdapter
extends IterableEntityAdapter<Bucket> {
    private static final String DB_CLASS = new OClassNameBuilder().type("bucket").build();
    public static final String P_REPOSITORY_NAME = "repository_name";
    public static final String P_PENDING_DELETION = "pendingDeletion";
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").build();
    private final ReadEntityByPropertyAction<Bucket> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"repository_name"});

    @Inject
    public BucketEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty("attributes", OType.EMBEDDEDMAP).setNotNull(true);
        type.createIndex(I_REPOSITORY_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME});
    }

    protected Bucket newEntity() {
        return new Bucket();
    }

    protected void readFields(ODocument document, Bucket entity) {
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        Map attributes = (Map)document.field("attributes", OType.EMBEDDEDMAP);
        entity.setRepositoryName(repositoryName);
        entity.attributes(new NestedAttributesMap("attributes", this.detachable(attributes)));
    }

    protected void writeFields(ODocument document, Bucket entity) {
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field("attributes", (Object)entity.attributes().backing());
    }

    @Nullable
    public Bucket read(ODatabaseDocumentTx db, String name) {
        return (Bucket)this.read.execute(db, new Object[]{name});
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        String repositoryName = (String)document.field(P_REPOSITORY_NAME);
        this.log.debug("newEvent: eventKind: {}, repositoryName: {}, metadata: {}", new Object[]{eventKind, repositoryName, metadata});
        switch (eventKind) {
            case CREATE: {
                return new BucketCreatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case UPDATE: {
                return new BucketUpdatedEvent((EntityMetadata)metadata, repositoryName);
            }
            case DELETE: {
                return new BucketDeletedEvent((EntityMetadata)metadata, repositoryName);
            }
        }
        return null;
    }
}

