/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.AssetStore;
import org.sonatype.nexus.repository.storage.Bucket;

@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Named
public class AssetStoreImpl
extends StateGuardLifecycleSupport
implements AssetStore,
Lifecycle {
    private final Provider<DatabaseInstance> databaseInstance;
    private final AssetEntityAdapter entityAdapter;

    @Inject
    public AssetStoreImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstance, AssetEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Asset getById(EntityId id) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return (Asset)this.entityAdapter.read(db, id);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Iterable<Asset> getByIds(Iterable<EntityId> ids) {
        return (Iterable)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.transform(this.entityAdapter.documents(db, ids)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public long countAssets(@Nullable Iterable<Bucket> buckets) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return this.entityAdapter.countByQuery(db, null, null, buckets, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public OIndex<?> getIndex(String indexName) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            return db.getMetadata().getIndexManager().getIndex(indexName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> List<Map.Entry<T, EntityId>> getNextPage(OIndexCursor cursor, int limit) {
        ArrayList<Map.Entry<T, EntityId>> page = new ArrayList<Map.Entry<T, EntityId>>(limit);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).acquire();){
            cursor.setPrefetchSize(limit);
            while (page.size() < limit) {
                Map.Entry entry = cursor.nextEntry();
                if (entry == null) {
                    break;
                }
                Object key = entry.getKey();
                AttachedEntityId value = new AttachedEntityId((EntityAdapter)this.entityAdapter, ((OIdentifiable)entry.getValue()).getIdentity());
                page.add(new AbstractMap.SimpleEntry(key, value));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return page;
    }

    @Override
    @Guarded(by={"STARTED"})
    public Asset save(Asset asset) {
        if (EntityHelper.hasMetadata((Entity)asset)) {
            OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
                ODocument oDocument = this.entityAdapter.editEntity(db, asset);
            });
            return asset;
        }
        return (Asset)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> (Asset)this.entityAdapter.readEntity((OIdentifiable)this.entityAdapter.addEntity(db, asset)));
    }

    @Override
    public void save(Iterable<Asset> assets) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> assets.forEach(asset -> {
            if (EntityHelper.hasMetadata((Entity)asset)) {
                this.entityAdapter.editEntity(db, (Entity)asset);
            } else {
                this.entityAdapter.addEntity(db, (Entity)asset);
            }
        }));
    }
}

