/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.Duration;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.repository.capability.GlobalRepositorySettings;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class AssetManager
extends ComponentSupport {
    public static final Duration DEFAULT_LAST_DOWNLOADED_INTERVAL = DateHelper.toJodaDuration((java.time.Duration)GlobalRepositorySettings.DEFAULT_LAST_DOWNLOADED_INTERVAL);
    private final GlobalRepositorySettings globalSettings;

    @Inject
    public AssetManager(GlobalRepositorySettings globalSettings) {
        this.globalSettings = (GlobalRepositorySettings)Preconditions.checkNotNull((Object)globalSettings);
    }

    public void setLastDownloadedInterval(Duration lastDownloadedInterval) {
        this.globalSettings.setLastDownloadedInterval(DateHelper.toJavaDuration((Duration)lastDownloadedInterval));
    }

    @VisibleForTesting
    public Duration getLastDownloadedInterval() {
        return DateHelper.toJodaDuration((java.time.Duration)this.globalSettings.getLastDownloadedInterval());
    }

    public boolean maybeUpdateLastDownloaded(Asset asset) {
        return asset.markAsDownloaded(this.getLastDownloadedInterval());
    }
}

