/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.node.NodeAccess;

public class AssetBlob {
    public static final boolean USE_HARD_DELETE = true;
    public static final boolean USE_SOFT_DELETE = false;
    private final NodeAccess nodeAccess;
    private final BlobStore blobStore;
    private final Function<BlobStore, Blob> blobFunction;
    private final String contentType;
    private final Map<HashAlgorithm, HashCode> hashes;
    private final boolean hashesVerified;
    private boolean attached;
    private Blob canonicalBlob;
    private Blob ingestedBlob;
    private boolean replicated = false;

    public AssetBlob(NodeAccess nodeAccess, BlobStore blobStore, Function<BlobStore, Blob> blobFunction, String contentType, Map<HashAlgorithm, HashCode> hashes, boolean hashesVerified) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
        this.blobFunction = (Function)Preconditions.checkNotNull(blobFunction);
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
        this.hashes = (Map)Preconditions.checkNotNull(hashes);
        this.hashesVerified = hashesVerified;
    }

    public boolean isDuplicate() {
        return this.canonicalBlob != null;
    }

    void setDuplicate(Blob canonicalBlob) {
        this.canonicalBlob = (Blob)Preconditions.checkNotNull((Object)canonicalBlob);
    }

    void delete(String reason) {
        this.delete(reason, false);
    }

    void delete(String reason, boolean useHardDelete) {
        if (this.ingestedBlob != null) {
            if (this.canonicalBlob != null || useHardDelete) {
                this.blobStore.deleteHard(this.ingestedBlob.getId());
            } else {
                this.blobStore.delete(this.ingestedBlob.getId(), reason);
            }
        }
    }

    boolean isAttached() {
        return this.attached;
    }

    void setAttached(boolean attached) {
        if (attached) {
            Preconditions.checkArgument((!this.attached ? 1 : 0) != 0, (Object)"Already attached");
        }
        this.attached = attached;
    }

    @Nonnull
    public BlobRef getBlobRef() {
        return new BlobRef(this.nodeAccess.getId(), this.blobStore.getBlobStoreConfiguration().getName(), this.getBlob().getId().asUniqueString());
    }

    @Nonnull
    public Blob getBlob() {
        if (this.canonicalBlob != null) {
            return this.canonicalBlob;
        }
        if (this.ingestedBlob == null) {
            this.ingestedBlob = (Blob)Preconditions.checkNotNull((Object)this.blobFunction.apply(this.blobStore));
        }
        return this.ingestedBlob;
    }

    public long getSize() {
        return this.getBlob().getMetrics().getContentSize();
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Nonnull
    public Map<HashAlgorithm, HashCode> getHashes() {
        return this.hashes;
    }

    public boolean getHashesVerified() {
        return this.hashesVerified;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    @VisibleForTesting
    Blob getIngestedBlob() {
        return this.ingestedBlob;
    }
}

