/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.DatabaseThreadUtils;
import org.sonatype.nexus.selector.VariableSource;

@Named
@Singleton
public class OrientContentAuthHelper {
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final ContentPermissionChecker contentPermissionChecker;

    @Inject
    public OrientContentAuthHelper(VariableResolverAdapterManager variableResolverAdapterManager, ContentPermissionChecker contentPermissionChecker) {
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
    }

    public boolean checkPathPermissions(String path, String format, String ... repositoryNames) {
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        VariableSource variableSource = variableResolverAdapter.fromPath(path, format);
        return DatabaseThreadUtils.withOtherDatabase(() -> Arrays.stream(repositoryNames).anyMatch(repositoryName -> this.contentPermissionChecker.isPermittedAnyOf(repositoryName, format, variableSource, new String[]{"browse", "read"})));
    }

    public boolean checkPathPermissionsJexlOnly(String path, String format, String ... repositoryNames) {
        VariableResolverAdapter variableResolverAdapter = this.variableResolverAdapterManager.get(format);
        VariableSource variableSource = variableResolverAdapter.fromPath(path, format);
        return DatabaseThreadUtils.withOtherDatabase(() -> Arrays.stream(repositoryNames).anyMatch(repositoryName -> this.contentPermissionChecker.isPermittedJexlOnlyAnyOf(repositoryName, format, variableSource, new String[]{"browse", "read"})));
    }
}

