/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.selector.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.selector.internal.OrientContentAuthHelper;

@Named
@Singleton
public class ContentAuth
extends OSQLFunctionAbstract {
    public static final String NAME = "contentAuth";
    private final OrientContentAuthHelper contentAuthHelper;

    @Inject
    public ContentAuth(OrientContentAuthHelper contentAuthHelper) {
        super(NAME, 3, 4);
        this.contentAuthHelper = (OrientContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        boolean jexlOnly;
        String path = (String)iParams[0];
        String format = (String)iParams[1];
        String browsedRepositoryName = (String)iParams[2];
        boolean bl = jexlOnly = iParams.length > 3 && (Boolean)iParams[3] != false;
        if (jexlOnly) {
            return this.contentAuthHelper.checkPathPermissionsJexlOnly(path, format, browsedRepositoryName);
        }
        return this.contentAuthHelper.checkPathPermissions(path, format, browsedRepositoryName);
    }

    public String getSyntax() {
        return "contentAuth(path, format, repositoryName, [jexlSelectorsOnly])";
    }
}

