/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.EntityLog;
import org.sonatype.nexus.repository.search.IndexBatchRequest;
import org.sonatype.nexus.repository.search.IndexRebuildManager;
import org.sonatype.nexus.repository.search.IndexRequestProcessor;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class IndexSyncService
extends LifecycleSupport {
    public static final String INDEX_UPGRADE_MARKER = "INDEX_UPGRADE_MARKER";
    private final Provider<DatabaseInstance> componentDatabase;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final NodeAccess nodeAccess;
    private final IndexRequestProcessor indexRequestProcessor;
    private final IndexRebuildManager indexRebuildManager;
    private final EntityLog entityLog;
    private final File checkpointFile;

    @Inject
    public IndexSyncService(@Named(value="component") Provider<DatabaseInstance> componentDatabase, ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, ApplicationDirectories directories, NodeAccess nodeAccess, IndexRequestProcessor indexRequestProcessor, IndexRebuildManager indexRebuildManager) {
        this.componentDatabase = (Provider)Preconditions.checkNotNull(componentDatabase);
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.indexRequestProcessor = (IndexRequestProcessor)((Object)Preconditions.checkNotNull((Object)((Object)indexRequestProcessor)));
        this.indexRebuildManager = (IndexRebuildManager)((Object)Preconditions.checkNotNull((Object)((Object)indexRebuildManager)));
        this.entityLog = new EntityLog(componentDatabase, new EntityAdapter[]{componentEntityAdapter, assetEntityAdapter});
        this.checkpointFile = new File(directories.getWorkDirectory("elasticsearch"), "nexus.lsn");
    }

    protected void doStart() throws Exception {
        this.indexRequestProcessor.start();
        try {
            Map changes = this.entityLog.since(this.loadCheckpoint());
            if (!changes.isEmpty()) {
                this.log.info("Applying {} incremental search updates", (Object)changes.size());
                this.syncIndex(changes);
            }
        }
        catch (EntityLog.UnknownDeltaException e) {
            this.logReason("Rebuilding search indexes because database has diverged", e);
            this.indexRebuildManager.rebuildAllIndexes();
        }
        catch (FileNotFoundException e) {
            if (!this.nodeAccess.isOldestNode()) {
                this.logReason("Rebuilding search indexes to match joining cluster", e);
                this.indexRebuildManager.rebuildAllIndexes();
            }
        }
        catch (Exception e) {
            this.log.warn("Unexpected error, skipping index sync", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        try {
            this.saveCheckpoint(this.entityLog.mark());
        }
        catch (IOException e) {
            this.log.warn("Problem saving {}", (Object)this.checkpointFile, (Object)e);
        }
        this.indexRequestProcessor.stop();
    }

    private void logReason(String message, Throwable cause) {
        if (this.log.isDebugEnabled()) {
            this.log.info(message, cause);
        } else {
            this.log.info(message);
        }
    }

    private void syncIndex(Map<ORID, EntityAdapter> changes) {
        IndexBatchRequest batch = new IndexBatchRequest();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabase.get()).acquire();){
            changes.forEach((rid, adapter) -> {
                ODocument document = (ODocument)db.load(rid);
                if (document != null) {
                    EntityId componentId = this.findComponentId(document);
                    if (componentId != null) {
                        batch.update(this.findRepositoryName(document), componentId);
                    }
                } else if (adapter instanceof ComponentEntityAdapter) {
                    batch.delete(null, this.componentId((ORID)rid));
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.indexRequestProcessor.process(batch);
    }

    private String findRepositoryName(ODocument document) {
        return (String)((ODocument)document.field("bucket")).field("repository_name");
    }

    @Nullable
    private EntityId findComponentId(ODocument document) {
        if (document.containsField("component")) {
            return this.componentId((ORID)document.field("component", ORID.class));
        }
        return this.componentId(document.getIdentity());
    }

    @Nullable
    private EntityId componentId(@Nullable ORID rid) {
        return rid != null ? new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, rid) : null;
    }

    @VisibleForTesting
    OLogSequenceNumber loadCheckpoint() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream in = new FileInputStream(this.checkpointFile);){
            byte[] nexusLsnBytes = ByteStreams.toByteArray((InputStream)in);
            if (Arrays.equals(nexusLsnBytes, INDEX_UPGRADE_MARKER.getBytes(StandardCharsets.UTF_8))) {
                throw new EntityLog.UnknownDeltaException("Index upgrade indicator found in Elasticsearch marker file");
            }
            return new OLogSequenceNumber((DataInput)ByteStreams.newDataInput((byte[])nexusLsnBytes));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void saveCheckpoint(OLogSequenceNumber checkpoint) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.checkpointFile));){
            checkpoint.toStream((DataOutput)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

