/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.search.ElasticSearchService;
import org.sonatype.nexus.repository.search.index.ElasticSearchIndexService;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.search.query.RepositoryQueryBuilder;

@Named(value="legacy")
@Singleton
public class ElasticSearchServiceImpl
extends ComponentSupport
implements ElasticSearchService {
    private final ElasticSearchIndexService elasticSearchIndexService;
    private final ElasticSearchQueryService elasticSearchQueryService;

    @Inject
    public ElasticSearchServiceImpl(ElasticSearchIndexService elasticSearchIndexService, ElasticSearchQueryService elasticSearchQueryService) {
        this.elasticSearchIndexService = (ElasticSearchIndexService)Preconditions.checkNotNull((Object)elasticSearchIndexService);
        this.elasticSearchQueryService = (ElasticSearchQueryService)Preconditions.checkNotNull((Object)elasticSearchQueryService);
    }

    public void createIndex(Repository repository) {
        this.elasticSearchIndexService.createIndex(repository);
    }

    public void deleteIndex(Repository repository) {
        this.elasticSearchIndexService.deleteIndex(repository);
    }

    public void rebuildIndex(Repository repository) {
        this.elasticSearchIndexService.rebuildIndex(repository);
    }

    public boolean indexExist(Repository repository) {
        return this.elasticSearchIndexService.indexExist(repository);
    }

    public boolean indexEmpty(Repository repository) {
        return this.elasticSearchIndexService.indexEmpty(repository);
    }

    public void put(Repository repository, String identifier, String json) {
        this.elasticSearchIndexService.put(repository, identifier, json);
    }

    public <T> List<Future<Void>> bulkPut(Repository repository, Iterable<T> components, Function<T, String> identifierProducer, Function<T, String> jsonDocumentProducer) {
        return this.elasticSearchIndexService.bulkPut(repository, components, identifierProducer, jsonDocumentProducer);
    }

    public void delete(Repository repository, String identifier) {
        this.elasticSearchIndexService.delete(repository, identifier);
    }

    public void bulkDelete(@Nullable Repository repository, Iterable<String> identifiers) {
        this.elasticSearchIndexService.bulkDelete(repository, identifiers);
    }

    public void flush(boolean fsync) {
        this.elasticSearchIndexService.flush(fsync);
    }

    public long getUpdateCount() {
        return this.elasticSearchIndexService.getUpdateCount();
    }

    public boolean isCalmPeriod() {
        return this.elasticSearchIndexService.isCalmPeriod();
    }

    public void waitForCalm() {
        this.elasticSearchIndexService.waitForCalm();
    }

    @Override
    public Iterable<SearchHit> browseUnrestricted(QueryBuilder query) {
        return this.browseUnrestrictedInRepos(query, null);
    }

    @Override
    public Iterable<SearchHit> browseUnrestrictedInRepos(QueryBuilder query, @Nullable Collection<String> repoNames) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query);
        if (repoNames != null) {
            repoQuery = repoQuery.inRepositories(repoNames);
        }
        return this.elasticSearchQueryService.browse((QueryBuilder)repoQuery.unrestricted());
    }

    @Override
    public Iterable<SearchHit> browse(QueryBuilder query) {
        return this.elasticSearchQueryService.browse(query);
    }

    @Override
    public SearchResponse searchUnrestrictedInRepos(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size, Collection<String> repoNames) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query).inRepositories(repoNames);
        if (sort != null) {
            repoQuery = repoQuery.sortBy(sort);
        }
        return this.elasticSearchQueryService.search((QueryBuilder)repoQuery.unrestricted(), from, size);
    }

    @Override
    public SearchResponse searchUnrestricted(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query);
        if (sort != null) {
            repoQuery = repoQuery.sortBy(sort);
        }
        return this.elasticSearchQueryService.search((QueryBuilder)repoQuery.unrestricted(), from, size);
    }

    @Override
    public SearchResponse search(QueryBuilder query, @Nullable List<SortBuilder> sort, int from, int size, @Nullable Integer seconds) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query);
        if (sort != null) {
            repoQuery = repoQuery.sortBy(sort);
        }
        if (seconds != null) {
            repoQuery = repoQuery.timeout(Duration.ofSeconds(seconds.intValue()));
        }
        return this.elasticSearchQueryService.search((QueryBuilder)repoQuery, from, size);
    }

    @Override
    public SearchResponse searchInReposWithAggregations(QueryBuilder query, List<AggregationBuilder> aggregations, Collection<String> repoNames) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query).inRepositories(repoNames);
        return this.elasticSearchQueryService.search((QueryBuilder)repoQuery, aggregations);
    }

    @Override
    public SearchResponse searchUnrestrictedInReposWithAggregations(QueryBuilder query, List<AggregationBuilder> aggregations, @Nullable List<SortBuilder> sort, Collection<String> repoNames) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query).inRepositories(repoNames);
        if (sort != null) {
            repoQuery = repoQuery.sortBy(sort);
        }
        return this.elasticSearchQueryService.search((QueryBuilder)repoQuery.unrestricted(), aggregations);
    }

    @Override
    public long countUnrestricted(QueryBuilder query) {
        RepositoryQueryBuilder repoQuery = RepositoryQueryBuilder.repositoryQuery((QueryBuilder)query);
        return this.elasticSearchQueryService.count((QueryBuilder)repoQuery.unrestricted());
    }
}

