/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.search.ComponentMetadataProducer;
import org.sonatype.nexus.repository.search.ComponentMetadataProducerExtension;
import org.sonatype.nexus.repository.search.JsonUtils;
import org.sonatype.nexus.repository.search.normalize.VersionNumberExpander;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Named
@Singleton
public class DefaultComponentMetadataProducer
implements ComponentMetadataProducer {
    public static final String ATTRIBUTES = "attributes";
    public static final String CONTENT_TYPE = "content_type";
    public static final String FORMAT = "format";
    public static final String NAME = "name";
    public static final String GROUP = "group";
    public static final String REPOSITORY_NAME = "repository_name";
    public static final String VERSION = "version";
    public static final String NORMALIZED_VERSION = "normalized_version";
    public static final String ASSETS = "assets";
    public static final String ID = "id";
    public static final String IS_PRERELEASE_KEY = "isPrerelease";
    public static final String LAST_BLOB_UPDATED_KEY = "lastBlobUpdated";
    public static final String LAST_DOWNLOADED_KEY = "lastDownloaded";
    public static final String UPLOADER = "uploader";
    public static final String UPLOADER_IP = "uploaderIp";
    public static final String REGEX_KEY = "regex";
    private static final Logger log = LoggerFactory.getLogger(DefaultComponentMetadataProducer.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd'T'HH:mm:ss.SSSZ");
    private final Set<ComponentMetadataProducerExtension> componentMetadataProducerExtensions;

    @Inject
    public DefaultComponentMetadataProducer(Set<ComponentMetadataProducerExtension> componentMetadataProducerExtensions) {
        this.componentMetadataProducerExtensions = (Set)Preconditions.checkNotNull(componentMetadataProducerExtensions);
    }

    @Override
    public String getMetadata(Component component, Iterable<Asset> assets, Map<String, Object> additional) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull(assets);
        Preconditions.checkNotNull(additional);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        DefaultComponentMetadataProducer.put(metadata, FORMAT, component.format());
        DefaultComponentMetadataProducer.put(metadata, GROUP, component.group());
        DefaultComponentMetadataProducer.put(metadata, NAME, component.name());
        DefaultComponentMetadataProducer.put(metadata, VERSION, component.version());
        DefaultComponentMetadataProducer.put(metadata, ATTRIBUTES, component.attributes().backing());
        String normalizedVersion = this.getNormalizedVersion(component);
        DefaultComponentMetadataProducer.put(metadata, NORMALIZED_VERSION, normalizedVersion);
        DefaultComponentMetadataProducer.put(metadata, IS_PRERELEASE_KEY, this.isPrerelease(component, assets));
        this.lastBlobUpdated(assets).ifPresent(dateTime -> DefaultComponentMetadataProducer.put(metadata, LAST_BLOB_UPDATED_KEY, dateTime.toString(DATE_TIME_FORMATTER)));
        this.lastDownloaded(assets).ifPresent(dateTime -> DefaultComponentMetadataProducer.put(metadata, LAST_DOWNLOADED_KEY, dateTime.toString(DATE_TIME_FORMATTER)));
        ArrayList<HashMap<String, Object>> allAssetMetadata = new ArrayList<HashMap<String, Object>>();
        for (Asset asset : assets) {
            HashMap<String, Object> assetMetadata = new HashMap<String, Object>();
            DefaultComponentMetadataProducer.put(assetMetadata, ID, this.documentId(asset));
            DefaultComponentMetadataProducer.put(assetMetadata, NAME, asset.name());
            DefaultComponentMetadataProducer.put(assetMetadata, CONTENT_TYPE, asset.contentType());
            DefaultComponentMetadataProducer.put(assetMetadata, ATTRIBUTES, asset.attributes().backing());
            DefaultComponentMetadataProducer.put(assetMetadata, UPLOADER, asset.createdBy());
            DefaultComponentMetadataProducer.put(assetMetadata, UPLOADER_IP, asset.createdByIp());
            allAssetMetadata.add(assetMetadata);
        }
        if (!allAssetMetadata.isEmpty()) {
            metadata.put(ASSETS, allAssetMetadata);
        }
        for (ComponentMetadataProducerExtension componentMetadataProducerExtension : this.componentMetadataProducerExtensions) {
            metadata.putAll(componentMetadataProducerExtension.getComponentMetadata(component));
        }
        metadata.putAll(additional);
        try {
            return JsonUtils.from(metadata);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    public Optional<DateTime> lastDownloaded(Iterable<Asset> assets) {
        return this.getDateTime(assets, Asset::lastDownloaded);
    }

    @VisibleForTesting
    public Optional<DateTime> lastBlobUpdated(Iterable<Asset> assets) {
        return this.getDateTime(assets, Asset::blobUpdated);
    }

    private Optional<DateTime> getDateTime(Iterable<Asset> assets, Function<Asset, DateTime> dateTimeFunction) {
        return Streams.stream(assets).map(dateTimeFunction).filter(Objects::nonNull).max(AbstractInstant::compareTo);
    }

    protected boolean isPrerelease(Component component, Iterable<Asset> assets) {
        return false;
    }

    private String documentId(Asset asset) {
        return EntityHelper.id((Entity)asset).getValue();
    }

    private static void put(Map<String, Object> metadata, String key, Object value) {
        if (value != null) {
            metadata.put(key, value);
        }
    }

    public String getNormalizedVersion(Component component) {
        return VersionNumberExpander.expand((String)component.version());
    }
}

