/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.internal.resources;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.ContinuationTokenHelper;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.BrowseService;
import org.sonatype.nexus.repository.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.rest.cma.AssetXOBuilder;
import org.sonatype.nexus.repository.rest.internal.resources.doc.AssetsResourceDoc;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;

@FeatureFlag(name="nexus.orient.enabled")
@Named
@Singleton
@Path(value="/v1/assets")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AssetsResource
extends ComponentSupport
implements Resource,
AssetsResourceDoc {
    public static final String RESOURCE_URI = "/v1/assets";
    private final BrowseService browseService;
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final MaintenanceService maintenanceService;
    private final ContinuationTokenHelper continuationTokenHelper;
    private final Map<String, AssetXODescriptor> assetDescriptors;

    @Inject
    public AssetsResource(BrowseService browseService, RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, AssetEntityAdapter assetEntityAdapter, MaintenanceService maintenanceService, @Named(value="asset") ContinuationTokenHelper continuationTokenHelper, Map<String, AssetXODescriptor> assetDescriptors) {
        this.browseService = (BrowseService)Preconditions.checkNotNull((Object)browseService);
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.continuationTokenHelper = (ContinuationTokenHelper)Preconditions.checkNotNull((Object)continuationTokenHelper);
        this.assetDescriptors = assetDescriptors;
    }

    @Override
    @GET
    public Page<AssetXO> getAssets(@QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="repository") String repositoryId) {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        PageResult<Asset> assetBrowseResult = this.browseService.browseAssets(repository, new QueryOptions(null, "id", "asc", Integer.valueOf(0), Integer.valueOf(10), this.lastIdFromContinuationToken(continuationToken)));
        List assetXOs = assetBrowseResult.getResults().stream().map(asset -> AssetXOBuilder.fromAsset(asset, repository, this.assetDescriptors)).collect(Collectors.toList());
        return new Page(assetXOs, assetBrowseResult.getTotal() > (long)assetBrowseResult.getResults().size() ? this.continuationTokenHelper.getTokenFromId((Entity)Iterables.getLast((Iterable)assetBrowseResult.getResults())) : null);
    }

    @Nullable
    private String lastIdFromContinuationToken(String continuationToken) {
        try {
            return this.continuationTokenHelper.getIdFromToken(continuationToken);
        }
        catch (ContinuationTokenHelper.ContinuationTokenException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            throw new WebApplicationException(406);
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    public AssetXO getAssetById(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIDXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIDXO.getRepositoryId());
        Asset asset = this.getAsset(id, repository, new DetachedEntityId(repositoryItemIDXO.getId()));
        return AssetXOBuilder.fromAsset(asset, repository, this.assetDescriptors);
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public void deleteAsset(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIDXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIDXO.getRepositoryId());
        DetachedEntityId entityId = new DetachedEntityId(repositoryItemIDXO.getId());
        Asset asset = this.getAsset(id, repository, entityId);
        if (repository != null && asset != null) {
            this.maintenanceService.deleteAsset(repository, asset);
        }
    }

    private Asset getAsset(String id, Repository repository, DetachedEntityId entityId) {
        try {
            return Optional.ofNullable(this.browseService.getAssetById(this.assetEntityAdapter.recordIdentity((EntityId)entityId), repository)).orElseThrow(() -> new NotFoundException("Unable to locate asset with id " + id));
        }
        catch (IllegalArgumentException e) {
            this.log.debug("IllegalArgumentException caught retrieving asset with id {}", (Object)entityId, (Object)e);
            throw new WebApplicationException(String.format("Unable to process asset with id %s", entityId), 422);
        }
    }
}

