/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rest.cma;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.storage.Asset;

public class AssetXOBuilder
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public AssetXOBuilder() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static AssetXO fromAsset(Asset asset, Repository repository, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        String internalId = EntityHelper.id((Entity)asset).getValue();
        Map checksum = asset.attributes().child(Asset.CHECKSUM).backing();
        String format = repository.getFormat().getValue();
        return AssetXO.builder().path(asset.name()).downloadUrl(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)repository.getUrl(), (CharSequence)"/"), (CharSequence)asset.name())).id(new RepositoryItemIDXO(repository.getName(), internalId).getValue()).repository(repository.getName()).checksum(checksum).format(format).contentType(asset.contentType()).attributes(AssetXOBuilder.getExpandedAttributes(asset, format, assetDescriptors)).lastModified(AssetXOBuilder.calculateLastModified(asset)).uploader(asset.createdBy()).uploaderIp(asset.createdByIp()).fileSize(asset.size().longValue()).build();
    }

    private static Date calculateLastModified(Asset asset) {
        DateTime dateTime = asset.blobUpdated();
        Date lastModified = dateTime != null ? dateTime.toDate() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)lastModified)) {
            Date date;
            DateTime dateTime2 = asset.blobCreated();
            lastModified = date = dateTime2 != null ? dateTime2.toDate() : null;
        }
        return lastModified;
    }

    private static Map getExpandedAttributes(Asset asset, String format, @Nullable Map<String, AssetXODescriptor> assetDescriptors) {
        LinkedHashMap expanded = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        DateTime dateTime = asset.blobCreated();
        Date date = dateTime != null ? dateTime.toDate() : null;
        DefaultGroovyMethods.putAt((Map)expanded, (Object)"blobCreated", (Object)date);
        DateTime dateTime2 = asset.lastDownloaded();
        Date date2 = dateTime2 != null ? dateTime2.toDate() : null;
        DefaultGroovyMethods.putAt((Map)expanded, (Object)"lastDownloaded", (Object)date2);
        Map<String, AssetXODescriptor> map = assetDescriptors;
        AssetXODescriptor assetXODescriptor = map != null ? map.get(format) : null;
        Set exposedAttributeKeys = assetXODescriptor != null ? assetXODescriptor.listExposedAttributeKeys() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)exposedAttributeKeys)) {
            NestedAttributesMap nestedAttributesMap = asset.attributes();
            NestedAttributesMap nestedAttributesMap2 = nestedAttributesMap != null ? nestedAttributesMap.child(format) : null;
            Map map2 = nestedAttributesMap2 != null ? nestedAttributesMap2.backing() : null;
            Map exposedAttributes = map2 != null ? DefaultGroovyMethods.subMap((Map)map2, (Collection)exposedAttributeKeys) : null;
            if (DefaultTypeTransformation.booleanUnbox((Object)exposedAttributes)) {
                expanded.put(format, exposedAttributes);
            }
        }
        return expanded;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetXOBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

