/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.repair;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class RepairMetadataComponent
extends ComponentSupport {
    private static final String BEGINNING_ID = "#-1:-1";
    private static final String ASSETS_WHERE = "@rid > :rid";
    private static final String ASSETS_SUFFIX = "ORDER BY @rid LIMIT :limit";
    private static final int BATCH_SIZE = 100;
    protected final RepositoryManager repositoryManager;
    protected AssetEntityAdapter assetEntityAdapter;
    protected final Type type;
    protected final Format format;

    public RepairMetadataComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, Type type, Format format) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.type = (Type)Preconditions.checkNotNull((Object)type);
        this.format = (Format)Preconditions.checkNotNull((Object)format);
    }

    public void repairRepository(Repository repository) {
        if (this.shouldRepairRepository(repository)) {
            this.doRepairRepository(repository);
        } else {
            this.log.info("Not running post processing after repairing {} repository {}", (Object)repository.getFormat(), (Object)repository.getName());
        }
    }

    protected void doRepairRepositoryWith(Repository repository, BiFunction<Repository, Iterable<Asset>, String> function) {
        String lastId = BEGINNING_ID;
        while (lastId != null) {
            try {
                lastId = this.processBatchWith(repository, lastId, function);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }
    }

    protected void doRepairRepository(Repository repository) {
        this.beforeRepair(repository);
        this.doRepairRepositoryWith(repository, this::updateAssets);
        this.afterRepair(repository);
        this.log.info("Finished processing all {} packages for repair", (Object)repository.getFormat());
    }

    @Nullable
    protected String processBatchWith(Repository repository, String lastId, BiFunction<Repository, Iterable<Asset>, String> function) throws Exception {
        return (String)TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).call(() -> {
            Iterable<Asset> assets = this.readAssets(repository, lastId);
            return (String)function.apply(repository, assets);
        });
    }

    @Nullable
    private String updateAssets(Repository repository, Iterable<Asset> assets) {
        String lastId = null;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        for (Asset asset : assets) {
            lastId = this.assetEntityAdapter.recordIdentity(asset).toString();
            this.updateAsset(repository, tx, asset);
        }
        return lastId;
    }

    protected Iterable<Asset> readAssets(Repository repository, String lastId) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        ImmutableMap parameters = ImmutableMap.of((Object)"rid", (Object)lastId, (Object)"limit", (Object)100);
        return storageTx.findAssets(ASSETS_WHERE, (Map<String, Object>)parameters, Collections.singletonList(repository), ASSETS_SUFFIX);
    }

    protected boolean shouldRepairRepository(Repository repository) {
        return repository.getFormat().equals((Object)this.format) && repository.getType().equals((Object)this.type);
    }

    protected void beforeRepair(Repository repository) {
    }

    protected void afterRepair(Repository repository) {
    }

    protected abstract void updateAsset(Repository var1, StorageTx var2, Asset var3);
}

