/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.repository.browse.internal.orient.BrowseNodeCollisionException;
import org.sonatype.nexus.repository.browse.internal.orient.OrientBrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.ossindex.PackageUrlService;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;

@Named
@Singleton
public class BrowseNodeEntityAdapter
extends IterableEntityAdapter<OrientBrowseNode> {
    private static final String DB_CLASS = new OClassNameBuilder().type("browse_node").build();
    public static final String P_REPOSITORY_NAME = "repository_name";
    public static final String P_FORMAT = "format";
    public static final String P_PATH = "path";
    public static final String P_PARENT_PATH = "parent_path";
    public static final String P_NAME = "name";
    public static final String P_PACKAGE_URL = "package_url";
    public static final String P_COMPONENT_ID = "component_id";
    public static final String P_ASSET_ID = "asset_id";
    public static final String AUTHZ_REPOSITORY_NAME = "authz_repository_name";
    private static final String BASE_PATH = "base_path";
    private static final String LIMIT = "limit";
    private static final String KEY = "key";
    private static final String I_REPOSITORY_NAME_PARENT_PATH_NAME = new OIndexNameBuilder().type(DB_CLASS).property("repository_name").property("parent_path").property("name").build();
    private static final String I_COMPONENT_ID = new OIndexNameBuilder().type(DB_CLASS).property("component_id").build();
    private static final String I_ASSET_ID = new OIndexNameBuilder().type(DB_CLASS).property("asset_id").build();
    private static final String FIND_BY_PARENT_PATH = String.format("select expand(rid) from index:%s where key=:%s limit 1", I_REPOSITORY_NAME_PARENT_PATH_NAME, "key");
    private static final String FIND_CHILDREN = String.format("select from %s where (%s=:%s and %s=:%s)", DB_CLASS, "repository_name", "repository_name", "parent_path", "base_path");
    private static final String CHILD_COUNT = String.format("select rid from `index:%s` where key=:%s limit :%s", I_REPOSITORY_NAME_PARENT_PATH_NAME, "key", "limit");
    private static final String FIND_BY_COMPONENT = String.format("select from %s where %s=:%s", DB_CLASS, "component_id", "component_id");
    private static final String FIND_BY_ASSET = String.format("select from %s where %s=:%s limit 1", DB_CLASS, "asset_id", "asset_id");
    private static final String DELETE_BY_REPOSITORY = String.format("delete from %s where %s=:%s limit :limit", DB_CLASS, "repository_name", "repository_name");
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;
    private final PackageUrlService packageUrlService;

    @Inject
    public BrowseNodeEntityAdapter(ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter, PackageUrlService packageUrlService) {
        super(DB_CLASS);
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.packageUrlService = (PackageUrlService)Preconditions.checkNotNull((Object)packageUrlService);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REPOSITORY_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_FORMAT, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PATH, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_PARENT_PATH, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_COMPONENT_ID, OType.LINK, this.componentEntityAdapter.getSchemaType());
        type.createProperty(P_ASSET_ID, OType.LINK, this.assetEntityAdapter.getSchemaType());
        type.createProperty(P_PACKAGE_URL, OType.STRING);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        this.defineType(type);
        type.createIndex(I_REPOSITORY_NAME_PARENT_PATH_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_REPOSITORY_NAME, P_PARENT_PATH, P_NAME});
        ODocument ignoreNullValues = db.newInstance().field("ignoreNullValues", (Object)true);
        type.createIndex(I_COMPONENT_ID, OClass.INDEX_TYPE.NOTUNIQUE.name(), null, ignoreNullValues, new String[]{P_COMPONENT_ID});
        type.createIndex(I_ASSET_ID, OClass.INDEX_TYPE.UNIQUE.name(), null, ignoreNullValues, new String[]{P_ASSET_ID});
    }

    protected OrientBrowseNode newEntity() {
        return new OrientBrowseNode();
    }

    protected void readFields(ODocument document, OrientBrowseNode entity) {
        ORID assetId;
        String repositoryName = (String)document.field(P_REPOSITORY_NAME, OType.STRING);
        String format = (String)document.field(P_FORMAT, OType.STRING);
        String path = (String)document.field(P_PATH, OType.STRING);
        String parentPath = (String)document.field(P_PARENT_PATH, OType.STRING);
        String name = (String)document.field(P_NAME, OType.STRING);
        String packageUrl = (String)document.field(P_PACKAGE_URL, OType.STRING);
        entity.setRepositoryName(repositoryName);
        entity.setFormat(format);
        entity.setPath(path);
        entity.setParentPath(parentPath);
        entity.setName(name);
        entity.setPackageUrl(packageUrl);
        ORID componentId = (ORID)document.field(P_COMPONENT_ID, ORID.class);
        if (componentId != null) {
            entity.setComponentId((EntityId)new AttachedEntityId((EntityAdapter)this.componentEntityAdapter, componentId));
        }
        if ((assetId = (ORID)document.field(P_ASSET_ID, ORID.class)) != null) {
            entity.setAssetId((EntityId)new AttachedEntityId((EntityAdapter)this.assetEntityAdapter, assetId));
        }
    }

    protected void writeFields(ODocument document, OrientBrowseNode entity) throws Exception {
        document.field(P_REPOSITORY_NAME, (Object)entity.getRepositoryName());
        document.field(P_FORMAT, (Object)entity.getFormat());
        document.field(P_PATH, (Object)entity.getPath());
        document.field(P_PARENT_PATH, (Object)entity.getParentPath());
        document.field(P_NAME, (Object)entity.getName());
        if (entity.getComponentId() != null) {
            document.field(P_PACKAGE_URL, (Object)entity.getPackageUrl());
            document.field(P_COMPONENT_ID, (Object)this.componentEntityAdapter.recordIdentity(entity.getComponentId()));
        }
        if (entity.getAssetId() != null) {
            document.field(P_ASSET_ID, (Object)this.assetEntityAdapter.recordIdentity(entity.getAssetId()));
        }
    }

    public void createComponentNode(ODatabaseDocumentTx db, String repositoryName, String format, List<? extends BrowsePath> paths, Component component) {
        this.maybeCreateParentNodes(db, repositoryName, format, paths.subList(0, paths.size() - 1));
        OrientBrowseNode node = BrowseNodeEntityAdapter.newNode(repositoryName, format, paths);
        ODocument document = BrowseNodeEntityAdapter.findNodeRecord(db, node);
        if (document == null) {
            EntityId componentId = EntityHelper.id((Entity)component);
            String packageUrl = this.packageUrlService.getPackageUrl(component.format(), component.group(), component.name(), component.version()).map(PackageUrl::toString).orElse(null);
            node.setPackageUrl(packageUrl);
            node.setComponentId(componentId);
            this.addEntity(db, (Entity)node);
        } else {
            ORID oldComponentId = (ORID)document.field(P_COMPONENT_ID, ORID.class);
            ORID newComponentId = this.componentEntityAdapter.recordIdentity(component);
            String packageUrl = this.packageUrlService.getPackageUrl(component.format(), component.group(), component.name(), component.version()).map(PackageUrl::toString).orElse(null);
            if (packageUrl != null || oldComponentId == null) {
                document.field(P_COMPONENT_ID, (Object)newComponentId);
                document.field(P_PACKAGE_URL, (Object)packageUrl);
                document.save();
            } else if (!oldComponentId.equals((Object)newComponentId)) {
                throw new BrowseNodeCollisionException("Node already has a component");
            }
        }
    }

    public void createAssetNode(ODatabaseDocumentTx db, String repositoryName, String format, List<? extends BrowsePath> paths, Asset asset) {
        this.maybeCreateParentNodes(db, repositoryName, format, paths.subList(0, paths.size() - 1));
        OrientBrowseNode node = BrowseNodeEntityAdapter.newNode(repositoryName, format, paths);
        ODocument document = BrowseNodeEntityAdapter.findNodeRecord(db, node);
        if (document == null) {
            node.setAssetId(EntityHelper.id((Entity)asset));
            this.addEntity(db, (Entity)node);
        } else {
            ORID oldAssetId = (ORID)document.field(P_ASSET_ID, ORID.class);
            ORID newAssetId = this.assetEntityAdapter.recordIdentity(asset);
            if (oldAssetId == null) {
                document.field(P_ASSET_ID, (Object)newAssetId);
                String path = (String)document.field(P_PATH, OType.STRING);
                if (!asset.name().endsWith("/") && path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                    document.field(P_PATH, (Object)path);
                }
                document.save();
            } else if (!oldAssetId.equals((Object)newAssetId)) {
                throw new BrowseNodeCollisionException("Node already has an asset");
            }
        }
    }

    private void maybeCreateParentNodes(ODatabaseDocumentTx db, String repositoryName, String format, List<? extends BrowsePath> paths) {
        int i = paths.size();
        while (i > 0) {
            ODocument document;
            OrientBrowseNode parentNode = BrowseNodeEntityAdapter.newNode(repositoryName, format, paths.subList(0, i));
            if (!parentNode.getPath().endsWith("/")) {
                parentNode.setPath(String.valueOf(parentNode.getPath()) + "/");
            }
            if ((document = BrowseNodeEntityAdapter.findNodeRecord(db, parentNode)) != null) {
                if (document.field(P_PATH).toString().endsWith("/")) break;
                document.field(P_PATH, (Object)(document.field(P_PATH) + "/"));
                document.save();
                break;
            }
            this.addEntity(db, (Entity)parentNode);
            --i;
        }
    }

    private static OrientBrowseNode newNode(String repositoryName, String format, List<? extends BrowsePath> paths) {
        OrientBrowseNode node = new OrientBrowseNode();
        node.setRepositoryName(repositoryName);
        node.setFormat(format);
        node.setPaths(paths);
        return node;
    }

    @Nullable
    private static ODocument findNodeRecord(ODatabaseDocumentTx db, OrientBrowseNode node) {
        return (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_PARENT_PATH)).execute(new Object[]{ImmutableMap.of((Object)KEY, (Object)BrowseNodeEntityAdapter.indexKey(node.getRepositoryName(), node.getParentPath(), node.getName()))})), null);
    }

    private static OCompositeKey indexKey(String ... keys) {
        return new OCompositeKey((Object[])keys);
    }

    public boolean assetNodeExists(ODatabaseDocumentTx db, EntityId assetId) {
        Iterable documents = (Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_ASSET)).execute(new Object[]{ImmutableMap.of((Object)P_ASSET_ID, (Object)this.recordIdentity(assetId))});
        return !Iterables.isEmpty((Iterable)documents);
    }

    public void deleteComponentNode(ODatabaseDocumentTx db, EntityId componentId) {
        Iterable documents = (Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_COMPONENT)).execute(new Object[]{ImmutableMap.of((Object)P_COMPONENT_ID, (Object)this.recordIdentity(componentId))});
        documents.forEach(document -> {
            if (document.containsField(P_ASSET_ID)) {
                document.removeField(P_COMPONENT_ID);
                document.save();
            } else {
                this.maybeDeleteParents(db, (String)document.field(P_REPOSITORY_NAME), (String)document.field(P_PARENT_PATH));
                document.delete();
            }
        });
    }

    public void deleteAssetNode(ODatabaseDocumentTx db, EntityId assetId) {
        ODocument document = (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_ASSET)).execute(new Object[]{ImmutableMap.of((Object)P_ASSET_ID, (Object)this.recordIdentity(assetId))})), null);
        if (document != null) {
            String repository = (String)document.field(P_REPOSITORY_NAME);
            String nodePath = StringUtils.appendIfMissing((String)StringUtils.prependIfMissing((String)((String)document.field(P_PATH)), (CharSequence)"/", (CharSequence[])new CharSequence[0]), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (document.containsField(P_COMPONENT_ID) || !this.hasNoChildren(db, repository, nodePath)) {
                document.removeField(P_ASSET_ID);
                document.save();
            } else {
                this.maybeDeleteParents(db, repository, (String)document.field(P_PARENT_PATH));
                document.delete();
            }
        }
    }

    public int deleteByRepository(ODatabaseDocumentTx db, String repositoryName, int limit) {
        return (Integer)db.command((OCommandRequest)new OCommandSQL(DELETE_BY_REPOSITORY)).execute(new Object[]{ImmutableMap.of((Object)P_REPOSITORY_NAME, (Object)repositoryName, (Object)LIMIT, (Object)limit)});
    }

    public List<OrientBrowseNode> getByPath(ODatabaseDocumentTx db, String repositoryName, List<String> path, int maxNodes, String assetFilter, Map<String, Object> filterParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(filterParameters);
        parameters.put(P_REPOSITORY_NAME, repositoryName);
        OCommandSQL sql = this.buildQuery(FIND_CHILDREN, assetFilter, maxNodes);
        String basePath = BrowseNodeEntityAdapter.joinPath(path);
        parameters.put(BASE_PATH, basePath);
        ArrayList children = Lists.newArrayList((Iterable)this.transform((Iterable)db.command((OCommandRequest)sql).execute(new Object[]{parameters})));
        children.forEach(child -> {
            if (this.childCountEqualTo(db, repositoryName, String.valueOf(child.getParentPath()) + child.getName() + "/", 0L)) {
                child.setLeaf(true);
            }
        });
        return children;
    }

    private void maybeDeleteParents(ODatabaseDocumentTx db, String repositoryName, String parentPath) {
        ODocument parent;
        if (!"/".equals(parentPath) && this.childCountEqualTo(db, repositoryName, parentPath, 1L) && (parent = (ODocument)Iterables.getFirst((Iterable)((Iterable)db.command((OCommandRequest)new OCommandSQL(FIND_BY_PARENT_PATH)).execute(new Object[]{ImmutableMap.of((Object)KEY, (Object)BrowseNodeEntityAdapter.indexKey(repositoryName, this.previousParentPath(parentPath), this.previousParentName(parentPath)))})), null)) != null && parent.field(P_COMPONENT_ID) == null && parent.field(P_ASSET_ID) == null) {
            this.maybeDeleteParents(db, repositoryName, (String)parent.field(P_PARENT_PATH));
            parent.delete();
        }
    }

    private String previousParentPath(String parentPath) {
        String withoutSlash = parentPath.substring(0, parentPath.length() - 1);
        return withoutSlash.substring(0, withoutSlash.lastIndexOf(47) + 1);
    }

    private String previousParentName(String parentPath) {
        String withoutSlash = parentPath.substring(0, parentPath.length() - 1);
        return withoutSlash.substring(withoutSlash.lastIndexOf(47) + 1);
    }

    private static String joinPath(List<String> path) {
        StringBuilder buf = new StringBuilder("/");
        path.forEach(s -> {
            StringBuilder stringBuilder2 = buf.append((String)s).append('/');
        });
        return buf.toString();
    }

    private OCommandSQL buildQuery(String select, String assetFilter, int limit) {
        StringBuilder buf = new StringBuilder(select);
        if (!assetFilter.isEmpty()) {
            buf.append(" and (").append(assetFilter).append(')');
        }
        buf.append(" limit ").append(limit);
        return new OCommandSQL(buf.toString());
    }

    public boolean resolveConflicts() {
        return true;
    }

    private boolean hasNoChildren(ODatabaseDocumentTx db, String repo, String path) {
        return this.childCountEqualTo(db, repo, path, 0L);
    }

    private boolean childCountEqualTo(ODatabaseDocumentTx db, String repositoryName, String basePath, long expected) {
        List docs = (List)db.command((OCommandRequest)new OCommandSQL(CHILD_COUNT)).execute(new Object[]{ImmutableMap.of((Object)KEY, (Object)BrowseNodeEntityAdapter.indexKey(repositoryName, basePath), (Object)LIMIT, (Object)(expected + 1L))});
        return (long)docs.size() == expected;
    }
}

