/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.repository.query.QueryOptions;

public class SuffixSqlBuilder {
    private final QueryOptions queryOptions;

    private SuffixSqlBuilder(QueryOptions queryOptions) {
        this.queryOptions = (QueryOptions)Preconditions.checkNotNull((Object)queryOptions);
    }

    public static String buildSuffix(QueryOptions queryOptions) {
        return new SuffixSqlBuilder(queryOptions).build();
    }

    private String build() {
        return String.valueOf(this.sort()) + this.start() + this.limit();
    }

    private String sort() {
        String sortProperty = this.queryOptions.getSortProperty();
        String sortDirection = this.queryOptions.getSortDirection();
        if (sortProperty != null && sortDirection != null && "id".equals(sortProperty)) {
            return " ORDER BY @rid " + sortDirection;
        }
        return "";
    }

    private String start() {
        Integer start = this.queryOptions.getStart();
        if (start != null) {
            return " SKIP " + start;
        }
        return "";
    }

    private String limit() {
        Integer limit = this.queryOptions.getLimit();
        if (limit != null) {
            return " LIMIT " + limit;
        }
        return "";
    }
}

