/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.internal.AssetWhereClauseBuilder;
import org.sonatype.nexus.repository.browse.internal.BrowseMetadataNodeSqlBuilderSupport;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.MetadataNodeEntityAdapter;

@Named
@Singleton
public class BrowseAssetsSqlBuilder
extends BrowseMetadataNodeSqlBuilderSupport {
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    BrowseAssetsSqlBuilder(AssetEntityAdapter assetEntityAdapter) {
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
    }

    protected MetadataNodeEntityAdapter<?> getEntityAdapter() {
        return this.assetEntityAdapter;
    }

    @Override
    protected String getBrowseIndex() {
        return AssetEntityAdapter.I_NAME_CASEINSENSITIVE;
    }

    @Override
    protected String buildWhereClause(List<String> bucketIds, QueryOptions queryOptions) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (!bucketIds.isEmpty()) {
            whereClauses.add("(" + bucketIds.stream().map(bucket -> "bucket = " + bucket).collect(Collectors.joining(" OR ")) + ")");
        }
        if (queryOptions.getContentAuth()) {
            whereClauses.add("contentAuth(@this.name, @this.format, :browsedRepository) == true");
        }
        return AssetWhereClauseBuilder.whereClause(Joiner.on((String)" AND ").join(whereClauses), queryOptions.getFilter() != null, queryOptions.getLastId() != null);
    }

    @Override
    Map<String, Object> buildSqlParams(String repositoryName, QueryOptions queryOptions) {
        String lastId;
        String filter;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (queryOptions.getContentAuth()) {
            params.put("browsedRepository", repositoryName);
        }
        if ((filter = queryOptions.getFilter()) != null) {
            params.put("nameFilter", "%" + filter + "%");
        }
        if ((lastId = queryOptions.getLastId()) != null) {
            params.put("rid", lastId);
        }
        return params;
    }
}

