/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.browse.internal.BrowseAssetIterator;
import org.sonatype.nexus.repository.selector.internal.OrientContentAuthHelper;

@Named
@Singleton
public class BrowseAssetIterableFactory
extends ComponentSupport {
    private final OrientContentAuthHelper contentAuthHelper;
    private final int pageSize;

    @Inject
    public BrowseAssetIterableFactory(OrientContentAuthHelper contentAuthHelper, @Named(value="${nexus.asset.browse.pageSize:-5000}") int pageSize) {
        this.contentAuthHelper = (OrientContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
        this.pageSize = pageSize;
    }

    public Iterable<ODocument> create(ODatabaseDocumentTx db, @Nullable String rid, String repositoryName, List<String> bucketIds, int limit) {
        return () -> new BrowseAssetIterator(this.contentAuthHelper, db, rid, repositoryName, bucketIds, limit, this.pageSize);
    }
}

