/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.repository.browse.node.BrowsePath;

public class BrowsePaths
extends BrowsePath {
    public BrowsePaths(String displayName, String requestPath) {
        super(displayName, requestPath);
    }

    public static List<BrowsePaths> fromPaths(List<String> paths, boolean trailingSlash) {
        ArrayList<BrowsePaths> results = new ArrayList<BrowsePaths>();
        StringBuilder requestPath = new StringBuilder();
        int i = 0;
        while (i < paths.size()) {
            requestPath.append(paths.get(i));
            if (trailingSlash || i < paths.size() - 1) {
                requestPath.append("/");
            }
            results.add(new BrowsePaths(paths.get(i), requestPath.toString()));
            ++i;
        }
        return results;
    }

    public static void appendPath(List<BrowsePaths> browsePaths, String path) {
        browsePaths.add(new BrowsePaths(path, String.valueOf(browsePaths.get(browsePaths.size() - 1).getRequestPath()) + path));
    }

    public static void appendPath(List<BrowsePaths> browsePaths, String path, String requestPath) {
        browsePaths.add(new BrowsePaths(path, requestPath));
    }
}

