/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

public abstract class AssetPathBrowseNodeGenerator
implements BrowseNodeGenerator {
    @Override
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        List nameParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)asset.name());
        return BrowsePaths.fromPaths(nameParts, false);
    }

    @Override
    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        return this.computeAssetPaths(asset, component);
    }
}

