/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.attributes.internal;

import javax.inject.Named;
import org.sonatype.nexus.common.collect.ImmutableNestedAttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.AttributeChange;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class AttributesFacetImpl
extends FacetSupport
implements AttributesFacet {
    @Override
    public ImmutableNestedAttributesMap getAttributes() {
        return (ImmutableNestedAttributesMap)Transactional.operation.withDb(((StorageFacet)this.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            NestedAttributesMap attributes = tx.findBucket(this.getRepository()).attributes();
            return new ImmutableNestedAttributesMap(null, attributes.getKey(), attributes.backing());
        });
    }

    @Override
    public void modifyAttributes(AttributeChange change) {
        TransactionalStoreMetadata.operation.withDb(((StorageFacet)this.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            change.apply(bucket.attributes());
            tx.saveBucket(bucket);
            return null;
        });
    }
}

