/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.group.deploy.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.group.deploy.GroupWriteFacet;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.RepositoryCacheInvalidationService;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named(value="groupWriteFacet")
public class GroupWriteFacetImpl
extends GroupFacetImpl
implements GroupWriteFacet {
    private final RepositoryManager repositoryManager;
    private GroupWriteConfig config;

    @Inject
    public GroupWriteFacetImpl(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType, RepositoryCacheInvalidationService repositoryCacheInvalidationService) {
        super(repositoryManager, constraintViolationFactory, groupType, repositoryCacheInvalidationService);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public Repository getWritableMember() {
        return this.getConfiguredWritableMember().map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).orElse(null);
    }

    protected Optional<String> getConfiguredWritableMember() {
        return Optional.ofNullable(this.config.groupWriteMember);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        super.doConfigure(configuration);
        this.config = (GroupWriteConfig)((Object)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, "group", GroupWriteConfig.class));
        this.log.debug("Config: {}", (Object)this.config);
    }

    static class GroupWriteConfig
    extends GroupFacetImpl.Config {
        @NotNull
        public String groupWriteMember;

        GroupWriteConfig() {
        }
    }
}

