/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.sonatype.nexus.repository.bower.rest.BowerHostedRepositoryApiRequest;
import org.sonatype.nexus.repository.rest.api.AbstractHostedRepositoriesApiResource;
import org.sonatype.nexus.repository.rest.api.model.AbstractRepositoryApiRequest;
import org.sonatype.nexus.validation.Validate;

@Api(value="Repository Management")
public abstract class BowerHostedRepositoriesApiResource
extends AbstractHostedRepositoriesApiResource<BowerHostedRepositoryApiRequest> {
    @ApiOperation(value="Create Bower hosted repository")
    @ApiResponses(value={@ApiResponse(code=201, message="Repository created"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    @POST
    @RequiresAuthentication
    @Validate
    public Response createRepository(BowerHostedRepositoryApiRequest request) {
        return super.createRepository((AbstractRepositoryApiRequest)request);
    }

    @ApiOperation(value="Update Bower hosted repository")
    @ApiResponses(value={@ApiResponse(code=204, message="Repository updated"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    @PUT
    @Path(value="/{repositoryName}")
    @RequiresAuthentication
    @Validate
    public Response updateRepository(BowerHostedRepositoryApiRequest request, @ApiParam(value="Name of the repository to update") @PathParam(value="repositoryName") String repositoryName) {
        return super.updateRepository((AbstractRepositoryApiRequest)request, repositoryName);
    }
}

