/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.rest;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.bower.rest.BowerAttributes;
import org.sonatype.nexus.repository.bower.rest.BowerProxyApiRepository;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;
import org.sonatype.nexus.repository.types.ProxyType;

@Named(value="bower")
public class BowerApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public BowerApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        if (repository.getType() instanceof ProxyType) {
            boolean online = repository.getConfiguration().isOnline();
            String name = repository.getName();
            String url = repository.getUrl();
            return new BowerProxyApiRepository(name, url, online, (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.createBowerAttributes(repository), this.getReplicationAttributes(repository));
        }
        return super.adapt(repository);
    }

    private BowerAttributes createBowerAttributes(Repository repository) {
        Boolean rewritePackageUrls = (Boolean)repository.getConfiguration().attributes("bower").get("rewritePackageUrls", Boolean.class);
        return new BowerAttributes(rewritePackageUrls);
    }
}

