/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.httpbridge.HttpResponseSender;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named(value="bower")
@Singleton
public class BowerHttpResponseSender
extends ComponentSupport
implements HttpResponseSender {
    private final HttpResponseSender defaultHttpResponseSender;

    @Inject
    public BowerHttpResponseSender(HttpResponseSender defaultHttpResponseSender) {
        this.defaultHttpResponseSender = (HttpResponseSender)Preconditions.checkNotNull((Object)defaultHttpResponseSender);
    }

    public void send(@Nullable Request request, Response response, HttpServletResponse httpResponse) throws ServletException, IOException {
        Status status = response.getStatus();
        Payload payload = response.getPayload();
        if (status.isSuccessful() || payload != null) {
            this.defaultHttpResponseSender.send(request, response, httpResponse);
        } else {
            String content = status.getMessage() == null ? "" : status.getMessage();
            StringPayload plainTextPayload = new StringPayload(content, "text/plain");
            this.defaultHttpResponseSender.send(request, new Response.Builder().status(status).payload((Payload)plainTextPayload).build(), httpResponse);
        }
    }
}

