/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.bower.internal.InvalidParametersException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
class BowerExceptionHandler
extends ComponentSupport
implements Handler {
    BowerExceptionHandler() {
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String action = context.getRequest().getAction();
        String path = context.getRequest().getPath();
        try {
            return context.proceed();
        }
        catch (IllegalOperationException e) {
            this.log.warn("Illegal operation: {} {}: {}", new Object[]{action, path, e.toString()});
            return HttpResponses.forbidden((String)e.getMessage());
        }
        catch (InvalidContentException e) {
            this.log.warn("Invalid content: {} {}: {}", new Object[]{action, path, e.toString()});
            if ("PUT".equals(action)) {
                return HttpResponses.badRequest((String)e.getMessage());
            }
            return HttpResponses.notFound((String)e.getMessage());
        }
        catch (InvalidParametersException e) {
            this.log.warn("Invalid parameters: {} {}: {}", new Object[]{action, path, e.toString()});
            return HttpResponses.badRequest((String)e.getMessage());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.warn("Service failure", (Throwable)e);
            return new Response.Builder().status(Status.failure((int)500, null)).build();
        }
    }
}

