/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Strings;
import com.google.inject.servlet.DynamicGuiceFilter;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.InstanceFilterBinding;
import com.google.inject.servlet.InstanceServletBinding;
import com.google.inject.servlet.LinkedFilterBinding;
import com.google.inject.servlet.LinkedServletBinding;
import com.google.inject.servlet.ServletDefinition;
import com.google.inject.servlet.ServletModuleTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PipelineLogger
extends DefaultBindingTargetVisitor<Object, String>
implements ServletModuleTargetVisitor<Object, String> {
    private static final String NL = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(DynamicGuiceFilter.class);
    private static final int PADDING = 30;
    private static final PipelineLogger THIS = new PipelineLogger();

    PipelineLogger() {
    }

    public static void dump(FilterDefinition[] filterDefinitions) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder("Updated filter definitions:");
            FilterDefinition[] filterDefinitionArray = filterDefinitions;
            int n = filterDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                FilterDefinition fd = filterDefinitionArray[n2];
                buf.append(NL).append((String)fd.acceptExtensionVisitor((BindingTargetVisitor)THIS, null));
                ++n2;
            }
            log.debug(buf.toString());
        }
    }

    public static void dump(ServletDefinition[] servletDefinitions) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder("Updated servlet definitions:");
            ServletDefinition[] servletDefinitionArray = servletDefinitions;
            int n = servletDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                ServletDefinition sd = servletDefinitionArray[n2];
                buf.append(NL).append((String)sd.acceptExtensionVisitor((BindingTargetVisitor)THIS, null));
                ++n2;
            }
            log.debug(buf.toString());
        }
    }

    public String visit(LinkedFilterBinding binding) {
        return PipelineLogger.format(binding.getPattern(), binding.getLinkedKey().getTypeLiteral());
    }

    public String visit(InstanceFilterBinding binding) {
        return PipelineLogger.format(binding.getPattern(), binding.getFilterInstance().getClass());
    }

    public String visit(LinkedServletBinding binding) {
        return PipelineLogger.format(binding.getPattern(), binding.getLinkedKey().getTypeLiteral());
    }

    public String visit(InstanceServletBinding binding) {
        return PipelineLogger.format(binding.getPattern(), binding.getServletInstance().getClass());
    }

    private static String format(String pattern, Object element) {
        return String.valueOf(Strings.padEnd((String)pattern, (int)30, (char)' ')) + ' ' + element;
    }
}

