/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Sets;
import com.google.inject.Key;
import com.google.inject.servlet.DynamicServletPipeline;
import com.google.inject.servlet.FilterChainInvocation;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.FilterPipelineMediator;
import com.google.inject.servlet.ManagedFilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import com.google.inject.servlet.PipelineLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.wire.EntryListAdapter;

@Singleton
final class DynamicFilterPipeline
extends ManagedFilterPipeline {
    private final DynamicServletPipeline servletPipeline;
    private final BeanLocator locator;
    private final List<FilterDefinition> filterDefinitions;
    private volatile FilterDefinition[] filterDefinitionCache = new FilterDefinition[0];
    private volatile ServletContext servletContext;

    @Inject
    DynamicFilterPipeline(DynamicServletPipeline servletPipeline, BeanLocator locator) {
        super(DynamicServletPipeline.DUMMY_INJECTOR, (ManagedServletPipeline)servletPipeline, null);
        this.servletPipeline = servletPipeline;
        this.locator = locator;
        try {
            super.initPipeline(null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.filterDefinitions = new EntryListAdapter(locator.locate(Key.get(FilterDefinition.class)));
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public synchronized void refreshCache() {
        Object[] snapshot = this.filterDefinitions.toArray();
        this.filterDefinitionCache = (FilterDefinition[])Arrays.copyOf(snapshot, snapshot.length, FilterDefinition[].class);
        PipelineLogger.dump(this.filterDefinitionCache);
        this.servletPipeline.refreshCache();
    }

    public synchronized void initPipeline(ServletContext context) throws ServletException {
        if (this.servletContext == null && context != null) {
            this.servletContext = context;
            this.locator.watch(Key.get(FilterPipeline.class), (Mediator)new FilterPipelineMediator(), (Object)this);
        }
    }

    public void dispatch(ServletRequest request, ServletResponse response, FilterChain proceedingFilterChain) throws IOException, ServletException {
        new FilterChainInvocation(this.filterDefinitions(), (ManagedServletPipeline)this.servletPipeline, proceedingFilterChain).doFilter(DynamicFilterPipeline.withDispatcher(request, this.servletPipeline), response);
    }

    public void destroyPipeline() {
        this.servletPipeline.destroy();
        Set destroyedSoFar = Sets.newIdentityHashSet();
        FilterDefinition[] filterDefinitionArray = this.filterDefinitions();
        int n = filterDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDefinition filterDefinition = filterDefinitionArray[n2];
            filterDefinition.destroy(destroyedSoFar);
            ++n2;
        }
    }

    private static ServletRequest withDispatcher(ServletRequest servletRequest, final DynamicServletPipeline servletPipeline) {
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        return new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return dispatcher != null ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }

    private FilterDefinition[] filterDefinitions() {
        return this.filterDefinitionCache;
    }
}

