/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.heartbeat.internal;

import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import com.sonatype.nexus.pro.systemchecks.heartbeat.internal.NodeHeartbeatDAO;
import com.sonatype.nexus.pro.systemchecks.heartbeat.internal.NodeHeartbeatData;
import java.time.OffsetDateTime;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="mybatis")
@Singleton
public class NodeHeartbeatStoreImpl
extends ConfigStoreSupport<NodeHeartbeatDAO>
implements NodeHeartbeatStore {
    private static final int DELETE_BATCH_SIZE_DEFAULT = SystemPropertiesHelper.getInteger((String)"nexus.content.deleteBatchSize", (int)1000);

    @Inject
    public NodeHeartbeatStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public void create(String nodeId, String hostname) {
        NodeHeartbeatData nodeEventsData = new NodeHeartbeatData(nodeId, hostname);
        ((NodeHeartbeatDAO)this.dao()).save(nodeEventsData);
    }

    @Override
    @Transactional
    public Continuation<NodeHeartbeatData> browse(@Nullable String continuationToken) {
        return ((NodeHeartbeatDAO)this.dao()).browse(continuationToken);
    }

    @Override
    @Transactional
    public List<NodeHeartbeatData> getLastTwoHeartbeats() {
        return ((NodeHeartbeatDAO)this.dao()).getLastTwoHeartbeats();
    }

    @Override
    @Transactional
    public boolean removeStale(OffsetDateTime cutoff) {
        boolean deleted = false;
        while (((NodeHeartbeatDAO)this.dao()).removeStale(cutoff, DELETE_BATCH_SIZE_DEFAULT)) {
            this.commitChangesSoFar();
            deleted = true;
        }
        return deleted;
    }

    private void commitChangesSoFar() {
        Transaction tx = UnitOfWork.currentTx();
        tx.commit();
        tx.begin();
        CancelableHelper.checkCancellation();
    }
}

