/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.heartbeat.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.sonatype.nexus.common.entity.ContinuationAware;

public class NodeHeartbeatData
implements ContinuationAware,
Serializable {
    private static final long serialVersionUID = 1225174334027832674L;
    @JsonIgnore
    Integer id;
    @JsonProperty
    private String nodeId;
    @JsonProperty
    private String hostname;
    @JsonProperty
    private OffsetDateTime heartbeatTime;

    private NodeHeartbeatData() {
    }

    public NodeHeartbeatData(String nodeId, String hostname) {
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
    }

    public OffsetDateTime heartbeatTime() {
        return this.heartbeatTime;
    }

    public String hostname() {
        return this.hostname;
    }

    public Integer id() {
        return this.id;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public void setHeartbeatTime(OffsetDateTime heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String nextContinuationToken() {
        return Integer.toString(this.id);
    }
}

