/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.heartbeat;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Named(value="Single Node Per Database")
@Singleton
public class NodeHeartbeatSystemCheck
extends HealthCheck {
    private final Provider<NodeHeartbeatManager> manager;

    @Inject
    public NodeHeartbeatSystemCheck(Provider<NodeHeartbeatManager> manager) {
        this.manager = (Provider)Preconditions.checkNotNull(manager);
    }

    protected HealthCheck.Result check() throws Exception {
        if (((NodeHeartbeatManager)((Object)this.manager.get())).isMultiNodeDetected()) {
            return HealthCheck.Result.unhealthy((String)"Multiple nodes have been detected interacting with external database. This is unsupported and will lead errors.");
        }
        return HealthCheck.Result.healthy((String)"Only single node detected.");
    }
}

