/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.heartbeat;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import com.sonatype.nexus.pro.systemchecks.heartbeat.internal.NodeHeartbeatData;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class NodeHeartbeatManager
extends LifecycleSupport {
    private final PeriodicJobService periodicJobService;
    private final NodeHeartbeatStore store;
    private final boolean enabled;
    private final int updateIntervalSec;
    private final int clearIntervalDays;
    private boolean detectedMultipleNodes = false;
    private String nodeId;
    private String hostname;
    private PeriodicJobService.PeriodicJob eventsTask;
    private PeriodicJobService.PeriodicJob clearTask;

    @Inject
    public NodeHeartbeatManager(NodeHeartbeatStore store, PeriodicJobService periodicJobService, @Named(value="${nexus.heartbeat.enabled:-true}") boolean enabled, @Named(value="${nexus.heartbeat.interval:-600}") int updateIntervalSec, @Named(value="${nexus.heartbeat.history:-30}") int clearIntervalDays) {
        this.store = (NodeHeartbeatStore)Preconditions.checkNotNull((Object)store);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.enabled = enabled;
        Preconditions.checkState((updateIntervalSec >= 0 ? 1 : 0) != 0, (Object)"Update interval should be positive");
        Preconditions.checkState((clearIntervalDays >= 0 ? 1 : 0) != 0, (Object)"Clear time interval should be positive");
        this.updateIntervalSec = updateIntervalSec;
        this.clearIntervalDays = clearIntervalDays;
    }

    protected void doStart() throws Exception {
        if (!this.enabled) {
            return;
        }
        this.nodeId = UUID.randomUUID().toString();
        this.hostname = this.getHostname();
        this.log.debug("Starting node events logging with time interval {} sec and cleanup out of {} days records", (Object)this.updateIntervalSec, (Object)this.clearIntervalDays);
        this.writeHeartbeat();
        this.periodicJobService.startUsing();
        this.eventsTask = this.periodicJobService.schedule(this::doHeartbeat, this.updateIntervalSec);
        this.clearTask = this.periodicJobService.schedule(this::clearStale, 43200);
    }

    protected void doStop() throws Exception {
        if (!this.enabled) {
            return;
        }
        this.eventsTask.cancel();
        this.clearTask.cancel();
        this.periodicJobService.stopUsing();
    }

    public boolean isMultiNodeDetected() {
        return this.detectedMultipleNodes;
    }

    private void doHeartbeat() {
        this.writeHeartbeat();
        Set otherNodeHeartbeats = this.store.getLastTwoHeartbeats().stream().filter(hb -> !this.nodeId.equals(hb.nodeId())).map(NodeHeartbeatData::hostname).collect(Collectors.toSet());
        boolean bl = this.detectedMultipleNodes = !otherNodeHeartbeats.isEmpty();
        if (this.detectedMultipleNodes) {
            this.log.error("Detected other nodes ({}) accessing database, this is unsupported and will break the system.", otherNodeHeartbeats);
        }
    }

    private void clearStale() {
        OffsetDateTime cutoff = OffsetDateTime.now().minusDays(this.clearIntervalDays);
        this.log.debug("Removing stale heartbeats before {}", (Object)cutoff);
        this.store.removeStale(cutoff);
    }

    private void writeHeartbeat() {
        this.log.debug("Write node id: {} to the DB", (Object)this.nodeId);
        this.store.create(this.nodeId, this.hostname);
    }

    private String getHostname() {
        Optional<Object> hostname;
        block14: {
            hostname = Optional.empty();
            try {
                Process process = Runtime.getRuntime().exec("hostname");
                process.waitFor(5L, TimeUnit.SECONDS);
                if (process.exitValue() != 0) break block14;
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream in = process.getInputStream();){
                    hostname = Optional.ofNullable(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.debug("Failed retrieve hostname from external process", (Throwable)e);
            }
        }
        if (hostname.isPresent()) {
            return (String)hostname.get();
        }
        try {
            hostname = Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception e) {
            this.log.debug("Failed to retrieve hostname from InetAddress", (Throwable)e);
        }
        return hostname.orElse("Unknown hostname");
    }
}

