/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.vulnerability;

import java.io.Serializable;
import java.util.Objects;
import org.sonatype.nexus.repository.vulnerability.SeverityLevel;

public class Vulnerability
implements Serializable {
    private static final long serialVersionUID = 8980455729226348235L;
    private final SeverityLevel severity;
    private final String description;
    private final String patchedIn;
    private final String moreInfo;

    public Vulnerability(SeverityLevel severity, String description, String patchedIn, String moreInfo) {
        this.severity = severity;
        this.description = description;
        this.patchedIn = patchedIn;
        this.moreInfo = moreInfo;
    }

    public SeverityLevel getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPatchedIn() {
        return this.patchedIn;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vulnerability that = (Vulnerability)o;
        return Objects.equals((Object)this.severity, (Object)that.severity) && Objects.equals(this.description, that.description) && Objects.equals(this.patchedIn, that.patchedIn) && Objects.equals(this.moreInfo, that.moreInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.description, this.patchedIn, this.moreInfo});
    }

    public String toString() {
        return String.format("severity: [%s] description: [%s] patchedIn: [%s] moreInfo: [%s] ", new Object[]{this.severity, this.description, this.patchedIn, this.moreInfo});
    }
}

