/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.vulnerability;

import java.util.Arrays;
import org.apache.commons.lang3.Range;

public enum SeverityLevel {
    CRITICAL("critical", "critical", (Range<Integer>)Range.between((Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(10))),
    HIGH("high", "severe", (Range<Integer>)Range.between((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(7))),
    MODERATE("moderate", "moderate", (Range<Integer>)Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3))),
    LOW("low", null, (Range<Integer>)Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)));

    private final String npmLevel;
    private final String iqLevel;
    private final Range<Integer> severityRange;

    private SeverityLevel(String npmLevel, String iqLevel, Range<Integer> severityRange) {
        this.npmLevel = npmLevel;
        this.iqLevel = iqLevel;
        this.severityRange = severityRange;
    }

    public static SeverityLevel calculateThreatCategory(int threatLevel) {
        return Arrays.stream(SeverityLevel.values()).filter(level -> level.severityRange.contains((Object)threatLevel)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public String getIqLevel() {
        return this.iqLevel;
    }

    public String getNpmLevel() {
        return this.npmLevel;
    }

    public Range<Integer> getSeverityRange() {
        return this.severityRange;
    }

    public String toString() {
        return String.format("npm lvl [%s] iq lvl [%s] severity range %s", this.npmLevel, this.iqLevel, this.severityRange);
    }

    public static SeverityLevel getSeverityLevelByIq(String iqLevel) {
        return Arrays.stream(SeverityLevel.values()).filter(a -> iqLevel.equalsIgnoreCase(a.getIqLevel())).findFirst().orElseThrow(() -> new IllegalArgumentException(iqLevel));
    }
}

