/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.vulnerability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.Vulnerability;

public class ComponentsVulnerability {
    private final Map<AuditComponent, List<Vulnerability>> components = new HashMap<AuditComponent, List<Vulnerability>>();

    public Map<AuditComponent, List<Vulnerability>> getAuditComponents() {
        return this.components;
    }

    public void addVulnerability(AuditComponent auditComponent, @Nullable Vulnerability vulnerability) {
        List vulnerabilities = this.components.computeIfAbsent(auditComponent, k -> new ArrayList());
        if (vulnerability != null) {
            vulnerabilities.add(vulnerability);
        }
    }

    public void addVulnerabilities(AuditComponent auditComponent, List<Vulnerability> vulnerabilities) {
        List oldVulnerabilities = this.components.computeIfAbsent(auditComponent, k -> new ArrayList());
        oldVulnerabilities.addAll(vulnerabilities);
    }

    public void addComponentsVulnerabilities(ComponentsVulnerability componentsVulnerability) {
        this.components.putAll(componentsVulnerability.getAuditComponents());
    }

    public String toString() {
        return this.components.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentsVulnerability that = (ComponentsVulnerability)o;
        return Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }
}

