/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.vulnerability;

import java.io.Serializable;
import java.util.Objects;

public class AuditComponent
implements Serializable {
    private static final long serialVersionUID = 470774542768031901L;
    private final String packageType;
    private final String name;
    private final String version;
    private final String appId;

    public AuditComponent(String appId, String packageType, String name, String version) {
        this.packageType = packageType;
        this.name = name;
        this.version = version;
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageUrl() {
        return "pkg:" + this.packageType + "/" + this.name + "@" + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditComponent auditComponent = (AuditComponent)o;
        return Objects.equals(this.appId, auditComponent.appId) && Objects.equals(this.packageType, auditComponent.packageType) && Objects.equals(this.name, auditComponent.name) && Objects.equals(this.version, auditComponent.version);
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.packageType, this.name, this.version);
    }

    public String toString() {
        return String.format("appId [%s] type [%s] name [%s] version [%s]", this.appId, this.packageType, this.name, this.version);
    }
}

