/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.ComponentUploadExtension;
import org.sonatype.nexus.repository.rest.internal.resources.ComponentUploadUtils;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.upload.UploadProcessor;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.internal.BlobStoreMultipartForm;
import org.sonatype.nexus.repository.upload.internal.UploadComponentMultipartHelper;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.rest.ValidationErrorsException;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class UploadManagerImpl
extends ComponentSupport
implements UploadManager {
    private final List<UploadDefinition> uploadDefinitions;
    private final Map<String, UploadHandler> uploadHandlers;
    private final UploadComponentMultipartHelper multipartHelper;
    private final UploadProcessor uploadComponentProcessor;
    private final Set<ComponentUploadExtension> componentUploadExtensions;
    private final EventManager eventManager;

    @Inject
    public UploadManagerImpl(Map<String, UploadHandler> uploadHandlers, UploadComponentMultipartHelper multipartHelper, UploadProcessor uploadComponentProcessor, EventManager eventManager, Set<ComponentUploadExtension> componentsUploadExtensions) {
        this.uploadHandlers = (Map)Preconditions.checkNotNull(uploadHandlers);
        this.uploadDefinitions = Collections.unmodifiableList(uploadHandlers.values().stream().map(UploadHandler::getDefinition).collect(Collectors.toList()));
        this.multipartHelper = (UploadComponentMultipartHelper)((Object)Preconditions.checkNotNull((Object)((Object)multipartHelper)));
        this.uploadComponentProcessor = (UploadProcessor)Preconditions.checkNotNull((Object)uploadComponentProcessor);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.componentUploadExtensions = (Set)Preconditions.checkNotNull(componentsUploadExtensions);
    }

    @Override
    public Collection<UploadDefinition> getAvailableDefinitions() {
        return this.uploadDefinitions;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UploadResponse handle(Repository repository, HttpServletRequest request) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)request);
        if (!repository.getConfiguration().isOnline()) {
            throw new ValidationErrorsException("Repository offline");
        }
        uploadHandler = this.getUploadHandler(repository);
        upload = this.create(repository, request);
        this.logUploadDetails(upload, repository);
        try {
            this.componentUploadExtensions.forEach((Consumer<ComponentUploadExtension>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(org.sonatype.nexus.repository.upload.ComponentUpload org.sonatype.nexus.repository.rest.ComponentUploadExtension ), (Lorg/sonatype/nexus/repository/rest/ComponentUploadExtension;)V)((ComponentUpload)upload));
            uploadResponse = uploadHandler.handle(repository, uploadHandler.getValidatingComponentUpload(upload).getComponentUpload());
            for (ComponentUploadExtension componentUploadExtension : this.componentUploadExtensions) {
                componentIds = uploadResponse.getContents().stream().map((Function<Content, Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, extractId(org.sonatype.nexus.repository.view.Content ), (Lorg/sonatype/nexus/repository/view/Content;)Ljava/util/Optional;)((UploadProcessor)this.uploadComponentProcessor)).filter((Predicate<Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPresent(), (Ljava/util/Optional;)Z)()).map((Function<Optional, EntityId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(), (Ljava/util/Optional;)Lorg/sonatype/nexus/common/entity/EntityId;)()).collect(Collectors.toList());
                componentUploadExtension.apply(repository, upload, componentIds);
            }
            this.eventManager.post((Object)new UploadManager.UIUploadEvent(repository, uploadResponse.getAssetPaths().stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).collect(Collectors.toList())));
            var11_9 = uploadResponse;
            return var11_9;
        }
        finally {
            ** for (assetUpload : upload.getAssetUploads())
        }
lbl-1000:
        // 1 sources

        {
            assetUpload.getPayload().close();
            continue;
        }
lbl27:
        // 1 sources

        return var11_9;
    }

    @Override
    public UploadDefinition getByFormat(String format) {
        Preconditions.checkNotNull((Object)format);
        UploadHandler handler = this.uploadHandlers.get(format);
        return handler != null ? handler.getDefinition() : null;
    }

    @Override
    public Content handle(ImportFileConfiguration importFileConfiguration) throws IOException {
        UploadHandler uploadHandler = this.getUploadHandler(importFileConfiguration.getRepository());
        if (importFileConfiguration.isHardLinkingEnabled()) {
            return uploadHandler.handle(importFileConfiguration);
        }
        return uploadHandler.handle(importFileConfiguration.getRepository(), importFileConfiguration.getFile(), importFileConfiguration.getAssetName());
    }

    private ComponentUpload create(Repository repository, HttpServletRequest request) throws IOException {
        try {
            BlobStoreMultipartForm multipartForm = this.multipartHelper.parse(repository, request);
            return ComponentUploadUtils.createComponentUpload(repository.getFormat().getValue(), multipartForm);
        }
        catch (FileUploadException e) {
            throw new IOException(e);
        }
    }

    private UploadHandler getUploadHandler(Repository repository) {
        if (!(repository.getType() instanceof HostedType)) {
            throw new ValidationErrorsException(String.format("Uploading components to a '%s' type repository is unsupported, must be '%s'", repository.getType().getValue(), "hosted"));
        }
        String repositoryFormat = repository.getFormat().toString();
        UploadHandler uploadHandler = this.uploadHandlers.get(repositoryFormat);
        if (uploadHandler == null) {
            throw new ValidationErrorsException(String.format("Uploading components to '%s' repositories is unsupported", repositoryFormat));
        }
        return uploadHandler;
    }

    private void logUploadDetails(ComponentUpload componentUpload, Repository repository) {
        if (this.log.isInfoEnabled()) {
            Map<String, String> componentFields = componentUpload.getFields();
            List<AssetUpload> assetUploads = componentUpload.getAssetUploads();
            StringBuilder sb = new StringBuilder();
            sb.append("Uploading component with parameters: ").append("repository").append("=\"").append(repository.getName()).append("\" ").append("format").append("=\"").append(repository.getFormat().getValue()).append("\" ");
            for (Map.Entry<String, String> entry : componentFields.entrySet()) {
                sb.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
            }
            this.log.info(sb.toString());
            for (AssetUpload assetUpload : assetUploads) {
                sb = new StringBuilder();
                sb.append("Asset with parameters: ");
                sb.append("file=\"").append(assetUpload.getPayload().getName()).append("\" ");
                for (Map.Entry<String, String> entry : assetUpload.getFields().entrySet()) {
                    sb.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\" ");
                }
                this.log.info(sb.toString());
            }
        }
    }

    private static /* synthetic */ void lambda$1(ComponentUpload componentUpload, ComponentUploadExtension componentUploadExtension) {
        componentUploadExtension.validate(componentUpload);
    }

    private static /* synthetic */ String lambda$5(String assetPath) {
        return StringUtils.prependIfMissing((String)assetPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

