/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload.internal;

import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class BlobStoreMultipartForm
implements AutoCloseable {
    private Map<String, TempBlobFormField> files = new HashMap<String, TempBlobFormField>();
    private Map<String, String> formFields = new HashMap<String, String>();

    public TempBlobFormField getFile(String fileName) {
        return this.files.get(fileName);
    }

    public Map<String, TempBlobFormField> getFiles() {
        return this.files;
    }

    public String getFormField(String formField) {
        return this.formFields.get(formField);
    }

    public Map<String, String> getFormFields() {
        return this.formFields;
    }

    public void putFile(String fieldName, TempBlobFormField file) {
        this.files.put(fieldName, file);
    }

    public void putFormField(String name, String value) {
        this.formFields.put(name, value);
    }

    @Override
    public void close() throws Exception {
        for (TempBlobFormField file : this.files.values()) {
            file.getTempBlob().close();
        }
    }

    public static class TempBlobFormField {
        private final String fieldName;
        private final String fileName;
        private final TempBlob tempBlob;

        public TempBlobFormField(String fieldName, String fileName, TempBlob tempBlob) {
            this.fieldName = fieldName;
            this.fileName = fileName;
            this.tempBlob = tempBlob;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public TempBlob getTempBlob() {
            return this.tempBlob;
        }
    }
}

